.\" $NCDId: @(#)soundtoh.man,v 1.1 1993/06/15 17:26:14 greg Exp $
.TH SOUNDTOH 1 "" "NCDware 3.2"
.SH NAME
soundtoh \- convert a sound file to a C language header file
.SH SYNOPSIS
.B soundtoh
filename
.SH DESCRIPTION
The \fIsoundtoh\fP program will convert a sound file in a format
supported by the NCDaudio library into a header file suitable for use
with the #include C pre\-processor directive.  The resulting output is
directed to the standard output.  The output will look something like:
.nf

/* bark */

#define barkDataFormat	AuFormatULAW8
#define barkSampleRate	8000
#define  barkNumTracks	1
#define barkNumSamples \\
    (sizeof(barkSamples) / sizeof(barkSamples[0]) / barkNumTracks)

static char *barkComment = "terrier bark";

static unsigned char barkSamples[] =
{
    0x57, 0x52, 0x51, 0x55, 0x5d, 0x72, 0xe5, 0xdc, 
    0xdc, 0xe2, 0xed, 0x76, 0x61, 0x5b, 0x59, 0x5e,
                       .
                       .
                       .
    0x66, 0xf0, 0xde, 0xe0, 0xf1, 0x6d, 0x67, 0x6a, 
    0x77, 0xee, 0xe5, 0xe6, 0xf1, 0x71, 0x6b, 
};

.fi
16\-bit samples will be converted appropriately depending upon the endianess
of the host machine.
.SH "SEE ALSO"
ncdaudio(1)
.SH COPYRIGHT
Copyright 1993 Network Computing Devices, Inc.
.SH AUTHOR
Greg Renda, Network Computing Devices, Inc.
