.\" $NCDId: @(#)aurecord.man,v 1.1 1993/06/21 18:13:12 greg Exp $
.TH AURECORD 1 "" "NCDware 3.2"
.SH NAME
aurecord \- record a sound file from an NCDaudio server
.SH SYNOPSIS
.B aurecord
[\-audio \fIservername\fP] [\-file \fIformat\fP] [\-data \fIformat\fP]
[\-rate \fIsample rate\fP] [\-mode \fIinput mode\fP] [\-gain \fIinput gain\fP]
[\-time \fIseconds\fP] [\-comment \fIcomment\fP] [\-?] \fIfilename\fP
.SH DESCRIPTION
The \fIaurecord\fP program can be used to record audio data from an
NCDaudio server into a file.  The recording will continue until
either the specified time has elapsed or \fIaurecord\fP receives a
SIGINT or SIGTERM signal.
.SH OPTIONS
The following options may be used with the \fIaurecord\fP program:
.IP "\fB\-audio\fP \fIservername\fP" 8
The NCDaudio server from which the file should be recorded.
.IP "\fB\-file\fP \fIformat\fP" 8
The file format to be used for the recorded audio data.  The \-? option will
display a list of valid file formats.  The default file format is
Sun/NeXT.
.IP "\fB\-data\fP \fIformat\fP" 8
The data format to be used for the recorded audio data.  The \-? option will
display a list of valid data formats.  Note that each file format may only
support selected data formats.  The default data format is 8-bit uLAW.
.IP "\fB\-rate\fP \fIsample rate\fP" 8
The sampling rate (in hertz) for the recording.  The default rate is 8000 Hz.
.IP "\fB\-mode\fP \fIinput mode\fP" 8
Some NCDaudio servers may have different input amplification modes for
microphone input versus line level input.  This option allows the amplification
mode to be specified.  The two modes available are "mic" for microphone input
and "line" for line level input.  The default mode is "mic".
.IP "\fB\-gain\fP \fIinput gain\fP" 8
The input gain level in percent.  The default is 75%.
.IP "\fB\-time\fP \fIseconds\fP" 8
The time, in seconds, for the recording.  If this option is not used,
\fIaurecord\fP will record until a SIGINT or SIGTERM signal is received.
.IP "\fB\-comment\fP \fIcomment\fP" 8
A comment to be stored in the data file.
.IP "\fB\-?\fP" 8
Displays a usage message and a list of supported file and data formats.
.SH "SEE ALSO"
ncdaudio(1)
.SH COPYRIGHT
Copyright 1993 Network Computing Devices, Inc.
.SH AUTHOR
Greg Renda, Network Computing Devices, Inc.
