.\" $NCDId: @(#)audial.man,v 1.7 1993/08/20 05:03:26 jan Exp $
.TH AUDIAL 1 "" "NCDware 3.2"
.SH NAME
audial \- generate or recognize touch tones for North American telephones
.SH SYNOPSIS
\fBaudial\fP
[\-audio \fIservername\fP]
[\-volume \fI0\-100\fP] 
[\-spacing \fImilliseconds\fP]
[\-pause \fImilliseconds\fP] 
[\-duration \fImilliseconds\fP]
\fIdialstring\fP
.PP
\fBaudial\fP
\-recognize
[\-microphone]
[\-gain \fI0\-100\fP]
[\-time \fIseconds\fP]
.SH DESCRIPTION
The \fIaudial\fP program generates touch tones suitable for dialing a 
North American telephone.  \fIaudial\fP can also recognize touch tones and
produce the corresponding string.
.SH GENERAL OPTIONS
The following options may be used in either dial or recognition mode:
.TP 8
.BI "\-audio " servername
This option specifies the NCDaudio server on which the files should be played.
.SH DIAL OPTIONS
The following options may be used in dial mode:
.TP 8
.BI "\-volume " "0\-100"
This option specifies the volume at which the data should be played as a 
percentage of the maximum possible volume.  The default is 100 percent.
.TP 8
.BI "\-spacing " "milliseconds"
This option specifies the number of milliseconds to wait in between each digit.
The default is 100.
.TP 8
.BI "\-pause " "milliseconds"
This option specifies the number of milliseconds to wait whenever a comma (,)
is used in a dial string.  The default is 400.
.TP 8
.BI "\-duration " "milliseconds"
This option specifies the duration of each tone in milliseconds.
The default is 100.
.SH "DIALING STRING"
The following characters may be used in a dialing string:
.TP 8
.I "0123456789*#"
The corresponding touch tone is generated.
.TP 8
.I "abcd"
Tones representing the 4 "function" keys often found on a keypad are generated.
.TP 8
.I ","
A blank tone whose length is specified by the \fI\-pause\fP option is
generated. 
.PP
Any other characters are ignored.
.SH RECOGNITION OPTIONS
.TP 8
.BI \-recognize
Enables recognition mode.  \fIaudial\fP will attempt to recognize touch tones
from the input device and output the corresponding character.
.TP 8
.BI \-microphone
Use microphone gain levels on the audio input device.  If a microphone is
plugged into the audio input jack, this option should be used.
.TP 8
.BI "\-gain " "0\-100"
This option specifies the input gain level.  The default is 95.
.TP 8
.BI "\-time " "seconds"
This option specifies how long to attempt the recognition.  The default
is forever.
.SH "ENVIRONMENT VARIABLES"
.PP
The following environment variables are used by \fIaudial\fP:
.TP 8
.B AUDIOSERVER
This specifies the name of default audio server to contact if no name is 
explicitly given on the command line.
.TP 8
.B DISPLAY
This specifies the name of an X Window System display that should be assumed
to also have a corresponding NCDaudio server.
.SH "SEE ALSO"
ncdaudio(1), auctl(1), audemo(1), autool(1)
.SH COPYRIGHT
Copyright 1993 Network Computing Devices, Inc.
.SH AUTHORS
Greg Renda, Network Computing Devices, Inc.
.br
Kevin Martin, Network Computing Devices, Inc.
