.\" $NCDId: @(#)audemo.man,v 1.10 1993/08/20 05:01:46 jan Exp $
.TH AUDEMO 1 "" "NCDware 3.2"
.SH NAME
audemo \- NCDAudio record and play demo
.IX audemo#(1) "" "\fLaudemo\fP(1)"
.SH SYNOPSIS
\fBaudemo\fP [\fB\-audio\fP \fIservername\fP] [\fB\-toolkitoption ...\fP]
[\fIdirectory\fP]
.SH DESCRIPTION
\fIaudemo\fP provides an X-based window-oriented user interface to the NCDaudio
service.  It allows the user to play pre-recorded sound files, record
new sound files and to manipulate NCDaudio buckets.
.SH AUDEMO AND THE ATHENA WIDGET SET
\fIaudemo\fP uses the X Toolkit Intrinsics and the Athena Widget Set.
For more information, see the Athena Widget Set documentation.
.SH SCREEN LAYOUT
\fIaudemo\fP starts out with a single window divided into several areas:
.IP \fBo\fP 4
A collection of command buttons.
.IP \fBo\fP 4
A left and right level meter.
.IP \fBo\fP 4
A volume indicator and control slider.
.IP \fBo\fP 4
An information window.
.IP \fBo\fP 4
An editable field containing the directory to be searched for sound
files.
.IP \fBo\fP 4
An editable field containing a list of sound files to search for.
.IP \fBo\fP 4
A window containing the list of sound files that may be selected for
playing or loading into buckets.
.SH PLAYING A SOUND FILE
To play a sound file you must first select it from the list of files
in the file window.  You can control which files are listed in this
window by editing the \fIDirectory\fP and/or \fITemplate\fP fields and
clicking on the \fIRescan\fP button.  To select a file, single-click
on the filename.  This will highlight the filename and display
information about the file in the information window.  The information
displayed includes:
.IP \fBFilename\fP 4
The full pathname of the file.
.IP "\fBFile Format\fP" 4
The file format of the audio file.
.IP "\fBData Format\fP" 4
The encoding format of the audio data.
.IP \fBTracks\fP 4
The number of tracks of audio data.
.IP \fBFrequency\fP 4
The frequency at which the audio data was sampled.
.IP \fBDuration\fP 4
The duration of the audio data in seconds.
.IP \fBText\fP 4
Any text information stored in the file.
.PP
Once the file has been selected, you can start it playing by clicking
on the \fIPlay\fP command button.  A shortcut for playing a file is to
double-click on the file name.  This will select the file and start it
playing.  When a file is playing, the \fIPlay\fP command button is
highlighted.  To stop the playing of a file, click on the highlighted
\fIPlay\fP button.  To enable the left and right level meters, click
on the \fIMeter\fP button before starting to play the file.  To
disable the left and right level meters, click again on the
highlighted \fIMeter\fP button.  To adjust the volume level, use the
volume slider.
.SH RECORDING TO A FILE
\fIaudemo\fP can record sound files in any supported file and data format.
To record a sound file you must first bring up the record window by
clicking on the \fIRecord\fP command button.  This will bring up a
window containing the following fields and controls:
.IP \fBFilename\fP 4
The name of the file you wish to create.  Unless a path is specified
here, the file will be created in the current directory.
.IP "\fBFile Format\fP" 4
A menu of file formats.
.IP "\fBData Format\fP" 4
A menu of data formats.  Note that each file format does not necessarily
support all of the data formats listed.
.IP "\fBMax Duration\fP" 4
See \fBRECORDING TO A BUCKET\fP.
.IP "\fBRead Only\fP" 4
See \fBRECORDING TO A BUCKET\fP.
.IP \fBFrequency\fP 4
The sampling rate (in hertz) for the recording.  Higher sampling rates
yield better quality sound but take up more disk and memory space.
Common sampling rates are 8000 (good for voice annotations), 11000,
22000, and 44000.
.IP \fBMic(rophone)\fP 4
This button tells the audio server if you've got a microphone attached
to the audio input jack.  Clicking this button will highlight it and
cause the audio server to boost the input gain to a level suitable for
recording with a microphone.
.IP \fBComment\fP 4
Text (such as a description) you wish to put into the audio file.
.IP \fBGain\fP 4
This slider is used to adjust the recording gain level.
.IP \fBRecord\fP 4
This button starts or stops the recording.
.IP \fBMonitor\fP 4
This button enables or disables monitoring.
.IP "\fBNew Bucket\fP" 4
See \fBRECORDING TO A BUCKET\fP.
.IP \fBDismiss\fP 4
This button stops recording and monitoring and closes the record
window.
.PP
Once you have selected the filename, file and data formats, frequency,
mic level, comment and gain, you are ready to record.  To listen in on
the audio that will be recorded you can click on the \fIMonitor\fP
button.  This will direct all the audio received from the audio input
jack to be played on the speaker.  When you're ready to record, click
on the \fIRecord\fP button.  All the audio received from the audio
input jack will now be recorded into the file.  The recording will
continue until you click on the \fIRecord\fP button again or click on
the \fIDismiss\fP button.  \fBNOTE:\fP Audio data can accumulate very
rapidly, especially at high sampling rates, resulting in large files.
.SH BUCKETS
The NCDaudio service provides the capability to create server resident
sound objects called \fIbuckets\fP.  \fIaudemo\fP allows the user to
create \fIbuckets\fP, record into them, play from them, load them with
data from a file and dump their contents into a file.  Note that
buckets created by \fIaudemo\fP are destroyed when \fIaudemo\fP is
terminated.  These options are available when you bring up the buckets
window by clicking on the \fIBuckets\fP button in the main window.
The buckets windows is divided into two areas:
.IP \fBo\fP 4
A collection of command buttons.
.IP \fBo\fP 4
A table of buckets currently accessible.  This table contains the
following columns:
.RS 4
.IP \fBDescription\fP 4
The text description.
.IP \fBDuration\fP 4
The duration of the audio data in seconds.
.IP \fBTracks\fP 4
The number of tracks of audio data.
.IP \fBFrequency\fP 4
The frequency at which the audio data was sampled.
.IP \fBFormat\fP 4
A code letter indicating the encoding format of the audio data.  A key
to the format code letters can be displayed by clicking on the
\fIFormat Key\fP button.
.IP \fBAccess\fP 4
A combination of code letters indicating the access mode of the
bucket.  A key to the access code letters can be displayed by clicking
on the \fIAccess Key\fP button.
.RE
.SH CREATING A BUCKET FROM A FILE
To create a bucket from from an audio data file, select the filename
from the list of files in the file window then click the \fILoad\fP
button in the buckets window.  The first line of the buckets table
should now contain the information about the newly created bucket.
.SH PLAYING FROM A BUCKET
To play a bucket, select the bucket you wish to play by clicking on
it's information in the buckets table.  The entry you click on should
be highlighted.  Then click on the \fIPlay\fP button in the buckets
window.  A shortcut for playing from a bucket is to double-click on
the bucket information.  This will select the bucket and start playing
from it.  To stop the playing of a bucket, click on the highlighted
\fIPlay\fP button in the buckets window.  The level meters and volume
level can be controlled in the same way as when playing from a file.
.SH RECORDING TO A BUCKET
To record into a new bucket, click on the \fIRecord\fP button in the
buckets window.  This will bring up the record window.  This record
window is the same as the one used for recording to files.  Instead of
specifying a filename, in the \fIMax Duration\fP field, enter the
maximum duration (in seconds) of data that the bucket is to hold.
Clicking on the \fIRead Only\fP button will prevent other applications
from writing into or destroying the bucket.  The frequency, mic
level, format and comment are used in the same way as when recording
to files.  Once all of the fields are set appropriately, click the
\fINew Buckett\fP button.  This will create a new bucket according to
the specifications given.  The first line of the buckets table
should now contain the information about the newly created bucket.  To
begin recording into the bucket, select the bucket by clicking on
it's information in the buckets table.  Then click the \fIRecord\fP
button in the record window.  All the audio received from the audio
input jack will now be recorded into the bucket.  The recording will
continue until you click on the \fIRecord\fP button again, click on
the \fIDismiss\fP or the bucket is filled.  The \fIGain\fP slider and
the \fIMonitor\fP button operate the same as when recording to a file.
.SH SAVING A BUCKET TO A FILE
To save a bucket to a file, first select the bucket by clicking on its
information in the buckets table.  Then click on the \fISave\fP button
in the buckets window.  A dialog box will pop up prompting you for the
name of the file in which to save the bucket data, and the file
format.  The data format used will be that of the bucket.  Note that
each file format may only support selected data formats.  If no path
is given in the filename, the file will be created in the current
directory.  Clicking on \fIOk\fP or pressing the \fBRETURN\fP key will
cause the file to be created and the data from the bucket to be
written to the file.
.SH DELETING A BUCKET
To delete a bucket, first select the bucket by clicking on
it's information in the buckets table.  Then click on the \fIDelete\fP
button in the buckets window.  If the \fIaudemo\fP has the appropriate
access permissions for the bucket, the bucket will be deleted and it's
information will be removed from the bucket table.
.SH EXITING AUDEMO
Clicking on the \fIQuit\fP button will cause \fIaudemo\fP to exit,
stopping any playing or recording operations and destroying any
buckets that were created.
.SH COMMAND LINE OPTIONS
.IP "\fB\-audio\fP \fIservername\fP" 8
This option specifies the NCDaudio server to which \fIaudemo\fP should connect.
.IP \fIdirectory\fP 8
The directory name that \fIaudemo\fP will use to build the list 
of selectable file names.  When \fIdirectory\fP is not specified on the 
command line, the current working directory is used.  
.SH EXAMPLES
In the following example, in a \fITCP/IP\fP network, \fImcxterm\fP is the 
name of the desktop machine running the audio server.  The default
port is \fI8000\fP and sound files are located in \fI~/snd\fP: 
.IP 
audemo \-audio tcp/mcxterm:8000 ~/snd 
.PP
In the following example, the shortened form of the audio server name is
used and sound files from the current working directory will be used:
.IP 
audemo \-audio mcxterm:0 
.SH ENVIRONMENT
.PP
In addition to the standard toolkit environment variables, the
following environment variables are used by \fIaudemo\fP:
.IP \fBAUDIOSERVER\fP 8
This variable specifies the default audio server to contact if \fI\-audio\fP
is not specified on the command line.  If this variable is not set and
the \fI\-audio\fP is not specified on the command line, \fIaudemo\fP
will attempt to connect to the audio server running on the
X Window System display.
.SH "SEE ALSO"
ncdaudio(1), auplay(1), autool(1), X(1)
.SH COPYRIGHT
Copyright 1993 Network Computing Devices, Inc.
.SH AUTHOR
Greg Renda, Network Computing Devices, Inc.

