/**
 * Copyright 1993 Network Computing Devices, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name Network Computing Devices, Inc. not be
 * used in advertising or publicity pertaining to distribution of this
 * software without specific, written prior permission.
 *
 * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
 * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
 * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
 * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
 * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
 * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
 * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * $NCDId: @(#)Xtutil.c,v 1.7 1993/12/04 00:06:41 greg Exp $
 *
 * This file contains utilities for writing Xt programs.
 */

#include <X11/Intrinsic.h>
#include <audio/Alibint.h>
#include "Xtutil.h"

typedef struct
{
    AuServer       *aud;
    XtAppContext    app_context;
    AuBool          syncWorkProcActive,
                    eventEnqWorkProcActive;
}               PrivData;


/* ARGSUSED */
void
AuXtHandleAudioEvents(closure, pfd, pinputid)
XtPointer       closure;
int            *pfd;
XtInputId      *pinputid;
{
    AuServer       *aud = (AuServer *) closure;

    AuHandleEvents(aud);
}


static          Boolean
_au_xt_syncWorkProc(data)
XtPointer       data;
{
    PrivData       *priv = (PrivData *) data;

    AuFlush(priv->aud);
    priv->syncWorkProcActive = AuFalse;
    return True;
}

static          Boolean
_au_xt_eventEnqWorkProc(data)
XtPointer       data;
{
    PrivData       *priv = (PrivData *) data;

    AuHandleEvents(priv->aud);
    priv->eventEnqWorkProcActive = AuFalse;
    return True;
}

/* ARGSUSED */
static void
_au_xt_synchandler(aud, handler, data)
AuServer       *aud;
AuSyncHandlerRec *handler;
XtPointer       data;
{
    PrivData       *priv = (PrivData *) data;

    if (!priv->syncWorkProcActive)
    {
	XtAppAddWorkProc(priv->app_context, _au_xt_syncWorkProc, priv);
	priv->syncWorkProcActive = AuTrue;
    }
}

/* ARGSUSED */
static void
_au_xt_eventenqhandler(aud, handler, event, data)
AuServer       *aud;
AuEventEnqHandlerRec *handler;
AuEvent        *event;
XtPointer       data;
{
    PrivData       *priv = (PrivData *) data;

    if (!priv->eventEnqWorkProcActive)
    {
	XtAppAddWorkProc(priv->app_context, _au_xt_eventEnqWorkProc, priv);
	priv->eventEnqWorkProcActive = AuTrue;
    }
}

XtInputId
AuXtAppAddAudioHandler(app_context, aud)
XtAppContext    app_context;
AuServer       *aud;
{
    PrivData       *priv;
    AuSyncHandlerRec *h;

    if (!(priv = (PrivData *) Aumalloc(sizeof(PrivData))))
	return 0;

    priv->app_context = app_context;
    priv->aud = aud;
    priv->syncWorkProcActive = AuFalse;
    priv->eventEnqWorkProcActive = AuFalse;

    if (!(h = AuRegisterSyncHandler(aud, _au_xt_synchandler, (XtPointer) priv)))
    {
	Aufree(priv);
	return 0;
    }

    if (!AuRegisterEventEnqHandler(aud, AuEventEnqueuedByReply,
				   _au_xt_eventenqhandler, (XtPointer) priv))
    {
	AuUnregisterSyncHandler(aud, h);
	Aufree(priv);
	return 0;
    }

    return XtAppAddInput(app_context, AuServerConnectionNumber(aud),
			 (XtPointer) XtInputReadMask, AuXtHandleAudioEvents,
			 (XtPointer) aud);
}
