.\" $NCDId: @(#)auscope.man,v 1.2 1993/03/03 20:56:00 mkm Exp $
.TH AUSCOPE 1 "" "NCDware 3.0"
.SH NAME
auscope \- NCDAudio Protocol Filter
.IX auscope#(1) "" "\fLauscope\fP(1)"
.SH SYNOPSIS
.B auscope
[ option ] ...
.SH DESCRIPTION
.I auscope
is an audio protocol filter, based on \fIxscope\fP, that can be used to view 
the network packets being sent between an audio application and an 
audio server.
.PP
To operate, 
.I 
auscope
must know the port on which it should listen for 
audio clients, the name of the desktop machine on which the audio server 
is running and the port to use to connect to the audio server.  Both the 
output port (server) and input port (client) are automatically biased by 
8000.  The output port defaults to 0 and the input port defaults to 1. 
.SH ARGUMENTS
.PP
.TP 8
.BI \-i "<input-port>"
Specify the port that \fIauscope\fP will use to take requests from clients. 
.PP
.TP 8
.BI \-o "<output-port>"
Determines the port that \fIauscope\fP will use to connect to the audio 
server. 
.PP
.TP 8
.BI \-h "<audio server name>"
Determines the desktop machine name that \fIauscope\fP will use to find 
the audio server.
.PP
.TP 8
.BI \-d "<display>"
Defines the display number.  The display number is added to the input
and output port to give the actual ports which are used by \fIauscope\fP.
.PP
.TP 8
.B \-q
Quiet output mode.  Prints only set up and connection information.  Does 
not display protocol information, or protocol requests, events, or errors.   
.PP
.TP 8
.BI \-v "<print-level>"
Determines the level of printing which \fIauscope\fP will provide.  The
print-level can be 0 (same as quiet mode), 1, 2, 3, 4.  The larger
numbers provide greater output detail. 
.PP
.TP 8
.BI \-D "<debug-level>"
Determines the level of debugging information which \fIauscope\fP will 
provide.  The debug-level defaults to 0.  The larger the number, the 
greater the output detail provided.  Useful levels are 1 and 7. 
.SH EXAMPLES
.PP
In the following example, \fImcxterm\fP is the name of the desktop machine 
running the audio server, which is connected to the TCP/IP network host
\fItcphost\fP.  \fIauscope\fP 
uses the desktop machine with the 
.B
-h
command line option, will listen for client requests on port 
8001 and connect to the audio server on port 8000.
.PP
Ports (file descriptors) on the network host are used to read and 
write the audio protocol.  The audio client 
.I
auplay
will connect to the audio server via the TCP/IP network host \fItcphost\fP 
and port \fI8001\fP:
.IP 
auscope -i1 -o0 -hmcxterm
.IP
auplay -audio tcp/tcphost:8001 dial.snd 
.PP
In the following example, the auscope verbosity is increased to 4 (the 
highest level), and the audio client 
.I
autool 
will connect to the audio server via the network host 
\fItcphost\fP, while displaying its graphical interface on another 
server \fIlabmcx\fP:
.IP
auscope -i1 -o0 -hmcxterm -v 4
.IP
autool -audio tcp/tcphost:8001 -display labmcx:0.0
.PP
In the following example, standard input is redirected from 
.I
/dev/null 
to prevent 
.I
auscope 
from stopping when put into the background.  Output is redirected to a 
file in \fI/tmp\fP.  Since the default input and output ports (1 and 0) 
are used, they are not required on the command line.  The audio 
client \fIauctl\fP connects in the manner previously described: 
.IP
auscope -hmcxterm < /dev/null > /tmp/auscope.out &
.IP
auctl -audio tcp/tcphost:8001 
.SH "SEE ALSO"
ncdaudio(1), auplay(1), autool(1)
.SH COPYRIGHT
Copyright 1993 Network Computing Devices, Inc.
.SH AUTHOR
Dave Lemke, Network Computing Devices, Inc.

