/* TunerApp.h -- copyright 1992 by C.D.Lane */

#import <appkit/appkit.h>
#import <soundkit/soundkit.h>
#import <musickit/musickit.h>

@interface TunerApp : Application
{
	id soundMeter, soundView;
	id centSlider, sharp, flat, attune;
	id sound, sample, version, defaults;
	id calibrationField, calibrationMatrix;
	id transpositionField, transpositionMatrix;
	id buttonMatrix, methodMatrix, helpScrollView;
	id squelchSlider, timeSlider, toleranceSlider, adjustmentSlider;

	MKKeyNum key, lastKey;
	DPSTimedEntry timedEntry;
	double frequency, amplitude;
}

- appDidInit:sender;
- free;

- willRecord:sender;
- didRecord:sender;

- windowDidBecomeKey:sender;

- computeFrequency;
- computeFrequencyViaFFT;

- showNoteName;
- clearNoteName;

- showCentError;
- clearCentError;

- switchMethod:(const char *) reason;

- setDefault:sender;
- setCalibration:sender;
- setTransposition:sender;

- printf:(const char *) format, ...;

- loadDefaults:sender;
- saveDefaults:sender;
- resetDefaults:sender;

- setVersion:anObject;

@end

@interface Sound(SimpleMethods)

- (int)	convertToFormat:(int) aFormat;

@end

#import <objc/NXStringTable.h>

@interface NXStringTable(DefaultsTable)

- registerDefaults:(const char *) owner;
- writeDefaults:(const char *) owner;
- updateDefaults;

- (int) applyToDefaults:(const char *) owner function:(int (*)(const char *, const NXDefaultsVector)) routine;

@end
