
//
//	convs2m		A stereo to monaural sound converter
//
//	1991/3/18
//	HiroshiMomose
//	Zoology, UCD, Davis, CA 95616   hmomose@ucdavis.edu
//
//	To compile this program, type : cc -O -g -o convs2m convs2m.c -lsys_s
//

#define title ("convs2m.c - converts a stereo 16 bit linear .snd file to monaural")

#import <sound/sound.h>
#import <stdio.h>

#define MONO	1
#define STEREO	2

check_error(int err)
{
    if (err) {
	fprintf(stderr, "Error : %s\n",SNDSoundError(err));
	exit(1);
    }
    return err;
}

main (int argc, char *argv[])
{

	int		i, size, width, temp, nsamples;
	int		datasize, dataformat, samplingrate, channelcount, info;
	char		channel = 'L';
	short int	ldata, rdata;
	char		*p;
	short int	*ip;
	SNDSoundStruct	*infile;	// for input, we use NeXT SND routines
	FILE		*outfile;	// for output, we don't.


	// ========== Check command line flag
	if ( argc == 4 )
		channel = toupper( argv[1][0] );
	if ( ( channel != 'L') && ( channel != 'R' ) ) {
		fprintf( stderr, "Error(convs2m) : wrong channel %c (must be L or R)\n", channel );
		exit( -1 );
	}	
	if( argc < 4 ) {
		fprintf( stderr, "%s\n\n", title );
		fprintf( stderr, "Usage : convs2m channel infile outfile\n\t" );
		fprintf( stderr, "channel must be either L or R (case does not matter)\n\t" );
		fprintf( stderr, "infile must be a 16bit linear stereo .snd file\n\t" );
		fprintf( stderr, "outfile will be a 16bit linear monaural .snd file\n\t" );
		fprintf( stderr, "Doesn't check if outfile already exists. So be careful.\n\n" );
		fprintf( stderr, "Sample operation : convs2m L stereo.snd mono.snd\n" );
		exit( -1 );
	}    

	// ========== Open input file
	check_error( SNDReadSoundfile( argv[2], &infile ));
	check_error( SNDGetDataPointer( infile, &p, &size, &width ));
							// probablly width is 2(bytes=16bit)
	ip = (short int *)p;

	// ========== Read input file header
	dataformat	= infile->dataFormat;
	datasize	= infile->dataSize;
	samplingrate	= infile->samplingRate;
	channelcount	= infile->channelCount;
	nsamples = datasize / channelcount / width;	// no. of data samples

	// ========== Check file format
	if( channelcount != STEREO ) {
		fprintf( stderr, "Error(convs2m) : Input file %s is not stereo\n", argv[1] );
		exit( -1 );
	}	
	if( dataformat != SND_FORMAT_LINEAR_16 ) {
		fprintf( stderr, "Error(convs2m) : Input file %s is not 16bit linear\n", argv[1] );
		exit( -1 );
	}	

	// ========== open output file
	if (( outfile = fopen ( argv[3], "wb" )) == 0 ) {
		fprintf( stderr, "Error(convs2m) : Can't open input file : %s\n", argv[1] );
		exit( -1 );
	}

	datasize /= 2;		// Size of the data will be half

	// ========== Write output file header	
	temp = SND_MAGIC;	fwrite( &temp, 4, 1, outfile );
	temp = 28;		fwrite( &temp, 4, 1, outfile );	// start point of sound data
	temp = datasize;	fwrite( &temp, 4, 1, outfile );	// no. of bytes in sound data
	temp = dataformat;	fwrite( &temp, 4, 1, outfile );
	temp = samplingrate;	fwrite( &temp, 4, 1, outfile );
	temp = MONO;		fwrite( &temp, 4, 1, outfile );	// channel count
	temp = 0x00000000;  	fwrite( &temp, 4, 1, outfile );	// info. string

	// ========== Write output sound data	
	if ( channel == 'L' ) {
		for ( i = 0; i < nsamples; i++ ) {
			ldata = ( *(ip++) );
			rdata = ( *(ip++) );
			fwrite ( &ldata, 2, 1, outfile );
		}
	} else {
		for ( i = 0; i < nsamples; i++ ) {
			ldata = ( *(ip++) );
			rdata = ( *(ip++) );
			fwrite ( &rdata, 2, 1, outfile );
		}
	}
	fclose( outfile );
	exit( 0 );
}


