/***********************************************************
Copyright 1991 by Stichting Mathematisch Centrum, Amsterdam, The
Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Play ulaw audio data read from stdin */

#define BUFFERSIZE 4000

#ifdef sgi
#define USE_AL
#endif
#ifdef sun
#define USE_SUN
#endif

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>

#ifdef USE_AL
#include <audio.h>
#include "libst.h"

long savestate[] = {
	AL_OUTPUT_RATE, 0,
};
#endif

#ifdef USE_SUN
#include <stropts.h>
#endif

/* getopt() interface */
extern int optind;
extern char * optarg;

/* Forward */
void cleanup_handler();

/* Globals */
char *progname;

main(argc, argv)
	int argc;
	char **argv;
{
	char buf[BUFFERSIZE];
	int n;
	int c;
	int ifd, ofd;
	int sts = 0;
#ifdef USE_AL
	short obuf[BUFFERSIZE];
	ALport aport;
	ALconfig config;
	int i;
	long pvbuf[2];
#endif

	progname = argv[0];
	while ((c = getopt(argc, argv, "")) != EOF) {
		switch (c) {
		case '?':
			usage();
		}
	}

	if (optind >= argc) {
		ifd = fileno(stdin);
	}
	else {
		if (optind+1 < argc)
			usage();
		ifd = open(argv[optind], 0);
		if (ifd < 0) {
			perror(argv[optind]);
			exit(1);
		}
	}

#ifdef USE_AL
	/* Fetch the original state */
	ALgetparams(AL_DEFAULT_DEVICE, savestate,
		    sizeof(savestate) / sizeof(long));

	/* Set signal handlers */
	signal(SIGINT, cleanup_handler);
	signal(SIGTERM, cleanup_handler);

	/* Set the output sampling rate to 8000 Hz */
	pvbuf[0] = AL_OUTPUT_RATE;
	pvbuf[1] = AL_RATE_8000;
	ALsetparams(AL_DEFAULT_DEVICE, pvbuf, 2L);

	/* Configure and open an SGI audio port */
	config = ALnewconfig();
	ALsetchannels(config, AL_MONO);
	ALsetwidth(config, AL_SAMPLE_16);
	ALsetqueuesize(config, 16000); /* 2 seconds slop */
	aport = ALopenport("radio", "w", config);
	if (aport == NULL) {
		perror("ALopenport");
		exit(1);
	}
#else
	/* Write to /dev/audio */
	if ((ofd = open("/dev/audio", O_WRONLY | O_NDELAY)) < 0) {
		perror("/dev/audio");
		exit(1);
	}
#endif

	for (;;) {
		n = read(ifd, buf, BUFFERSIZE);
		if (n <= 0) {
			if (n < 0) {
				perror("read");
				sts = 1;
			}
			break;
		}
#ifdef USE_AL
		for (i = 0; i < n; i++)
			obuf[i] = st_ulaw_to_linear(buf[i]);
		ALwritesamps(aport, obuf, (long)n);
#else
		if (write(ofd, buf, n) != n) {
			perror("write");
			sts = 1;
			break;
		}
#endif
	}

#ifdef USE_AL
	/* Wait until all sound has played */
	while(ALgetfilled(aport) > 0) /* still sound to play */
		sginap(1);	/* sleep for 1/60 of a second */

	/* Restore the output sampling rate */
	ALsetparams(AL_DEFAULT_DEVICE, savestate,
		    sizeof(savestate) / sizeof(long));
#endif

	exit(sts);
}

usage()
{
	fprintf(stderr, "usage: %s [file]\n", progname);
	exit(2);
}

#ifdef USE_AL

void cleanup_handler(sig)
	int sig;
{
	signal(sig, SIG_DFL);
	ALsetparams(AL_DEFAULT_DEVICE, savestate,
		    sizeof(savestate) / sizeof(long));
	kill(getpid(), sig);
}

#endif /* USE_AL */
