/***********************************************************
Copyright 1991 by Stichting Mathematisch Centrum, Amsterdam, The
Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Socket-related subroutines shared by broadcast and radio */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <netdb.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>

int
opensock(sockdesc, localname, localport, remotename, remoteport, broadcast)
	char *sockdesc;
	char *localname;
	int localport;
	char *remotename;
	int remoteport;
	int broadcast;
{
	int s;
	struct sockaddr_in sin;
	char desc[512];

	s = socket(AF_INET, SOCK_DGRAM, 0);
	if (s < 0) {
		sprintf(desc, "socket(%s)", sockdesc);
		perror(desc);
		exit(1);
	}
	memset((char *)&sin, '\0', sizeof(sin));
	if(localname) {
		setipaddr(localname, &sin);
	}
	else {
		sin.sin_addr.s_addr = INADDR_ANY;
		sin.sin_family = AF_INET;
	}
	sin.sin_port = htons(localport);

	if (bind(s, &sin, sizeof sin) < 0) {
		sprintf(desc,"bind(%s)", sockdesc);
		perror(desc);
		exit(1);
	}

	if(remotename) {
		memset((char *)&sin, '\0', sizeof(sin));
		setipaddr(remotename, &sin);
		sin.sin_port = htons(remoteport);

		if (connect(s, &sin, sizeof sin) < 0) {
			sprintf(desc, "connect(%s)", sockdesc);
			perror(desc);
			exit(1);
		}
	}

	if(broadcast) {
		int on = 1;
		if (setsockopt(s, SOL_SOCKET, SO_BROADCAST,
				&on, sizeof (on)) < 0) {
			sprintf(desc,"setsockopt(%s, SO_BROADCAST)", sockdesc);
			perror(desc);
			exit(1);
		}
	}
	return s;
}

int
setipaddr(name, addr_ret)
        char *name;
        struct sockaddr_in *addr_ret;
{
        struct hostent *hp;

        if((hp = gethostbyname(name)) == NULL) {
                if((addr_ret->sin_addr.s_addr = inet_addr(name)) == -1) {
                        return(-1);
                }
        }
	else  {
                memcpy((char *) &addr_ret->sin_addr, hp->h_addr, hp->h_length);
        }
        addr_ret->sin_family = AF_INET;
        return 4;
}
