.TH BROADCAST 1
.SH NAME
broadcast \- send audio UDP packets to be received by radio
.SH SYNOPSIS
.B broadcast
[
.BI \-p port
] [
.BI \-b addr
] ... [
.BI \-c port
] [
.BI \-t
] [
.BI \-d
]
.SH DESCRIPTION
.I Broadcast
reads audio data in U-LAW format (8000 samples/second, 1 byte/sample,
logarithmically encoded) from standard input, chops it up into packets
of 1400 bytes each, and transmits these as UDP broadcast packets.
On a typical ethernet, this uses about 1 percent of the net available
bandwith (less than 6 packets per second).
.PP
It is possible to use multiple transmission stations (each identified
by a different UDP port), and to transmit to multiple connected
subnets simultaneously, as long as the gateways let UDP broadcast
packets through.
Each transmission station should run on a different host though.
.SH OPTIONS
.TP 10
.BI \-p port
Transmit to this UDP port number (default 54321).
.TP 10
.BI \-b addr
IP address to send to (default broadcast on local net).
The address may be a host name (for unicast) or an IP multicast
address (last bvyte 0 or 255).
More than one
.B \-b
option may be given; the data is sent to each address.
.TP 10
.BI \-c port
Use this UDP port number as control port (default 54320).
Normally you never need to change this; the control port is used by
optional ``tuner'' software (not distributed).
.TP 10
.B \-t
When the input is faster than real time, e.g., read from a file, this
option ensures that the packets are sent out at the correct rate.
Normally, it is presumed that the standard input provides the data at
the correct rate (8000 bytes/sec).
.TP 10
.B \-d
Turn on debugging (a message on stderr for each 8 packets sent).
.SH AUTHOR
Guido van Rossum
.SH VERSION
This manual page documents broadcast version 1.0, patchlevel 3.
