.TH RADIO 1
.SH NAME
radio \- receive audio UDP packets transmitted by broadcast
.SH SYNOPSIS
.B radio
[
.BI \-p port
] [
.BI \-v volume
] [
.B \-f
] [
.B \-n
] [
.BI \-c port
] [
.B \-s
] [
.BI \-l addr
] [
.BI -r addr
] [
.B \-d
]
.SH DESCRIPTION
.I Radio
allows you to listen to audio transmitted as UDP packets on a local
area network by
.IR broadcast (1).
Obviously, this requires a workstation with audio hardware; currently
the program works on SGI Indigo and 4D/35 worstations, Sun Sparcs, and
all NeXTs.
.PP
.I Radio
is normally run in the background.
You may need a system-specific tool to change the volume or direct the
output to the speaker or headphone jack; e.g., on an SGI, you would
use
.IR apanel (1);
 on a Sun you would use
.IR gaintool(1)
or, when using X,
.IR x_gaintool(1)
(these programs can be found in /usr/demo/SOUND in SunOS 4.1).
.PP
Some loss of UDP packets is tolerated; this is heard as short
nterruptions of the sound.
.SH OPTIONS
.TP 10
.BI \-p port
Receive packets sent to this UDP port number (default 54321).
This corresponds to the port used by
.I broadcast.
Port numbers 1..99 are shorthands for 54321..54419.
.TP 10
.BI \-v volume
Set the initial volume, on a scale from 0 to 100.  (SGI and Sun Sparc only.)
By default, the volume is left unchanged.
.TP 10
\fB-f\fR
Filter mode: write the U-LAW audio data to stdout instead of
sending it to the audio hardware.
.TP 10
\fB-n\fR
Noninterruptable mode (Sun Sparc only).
By default, radio notices when another program wants to output the
audio output device, and temporarily ``backs off'' until the other
program is finished, hoping it won't take too long.
This option turns off that feature.
.TP 10
\fB-c \fIport\fR
Use this UDP port number as control port (default 54320).
Normally you never need to change this; the control port is used by
optional ``tuner'' software (not distributed) and possibly by listener
poll programs.
.TP 10
\fB-s\fR
Secure mode: don't listen to the control port.
.TP 10
\fB-l \fIaddr\fR
Listen only for packets to IP address
.I addr
(useful for forwarding stations).
.TP 10
\fB-r \fIaddr\fR
Listen only for packets from IP address
.I addr
(useful for forwarding stations).
.TP 10
\fB-d\fR
Turn on debugging (a message on stderr for each 8 packets received,
and when rare or unexpected events happen).
.SH AUTHOR
Guido van Rossum
.SH VERSION
This manual page documents radio version 1.0, patchlevel 3.
