#! /usr/local/python

# /***********************************************************
# Copyright 1991 by Stichting Mathematisch Centrum, Amsterdam, The
# Netherlands.
# 
#                         All Rights Reserved
# 
# Permission to use, copy, modify, and distribute this software and its 
# documentation for any purpose and without fee is hereby granted, 
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in 
# supporting documentation, and that the names of Stichting Mathematisch
# Centrum or CWI not be used in advertising or publicity pertaining to
# distribution of the software without specific, written prior permission.
# 
# STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# 
# ******************************************************************/

# Radio listening statistics.
#
# usage: nielsen [-w] [port]
# -w	print who's logged on (slow)
# port	alternate port to broadcast to
#
# XXX should understand -b options as well, instead of hardwiring addresses.

import sys, posix, time, string
from socket import *

print 'getting hosts...',
sys.stdout.flush()
hosts = {}
for line in posix.popen('ypcat hosts', 'r').readlines():
	words = string.split(line)
	if len(words) >= 2:
		hosts[words[0]] = words[1:]
print 'done.'

addrlist = '192.16.184.0', '192.16.191.0', '192.16.201.255'
port = 54320
who = 0
if sys.argv[1:2] = ['-w']: who = 1; sys.argv[1:2] = []
if sys.argv[1:]: port = eval(sys.argv[1])

s = socket(AF_INET, SOCK_DGRAM)
s.allowbroadcast(1)
for addr in addrlist:
	s.sendto('radio:i', (addr, port))

try:
	while 1:
		# Time-out if no next response within 5 seconds
		for i in range(5):
			if s.avail(): break
			else: time.sleep(1)
		else:
			print 'Time-out -- assume no more responses.'
			break # out of the enclosing while loop
		data, (host, port) = s.recvfrom(1400)
		print data, host,
		if hosts.has_key(host):
			host = hosts[host][0]
			print host,
		print
		if who:
			cmd = 'who | sed \'s/ .*//\' | sort -u'
			sts = posix.system('rsh ' + host + ' "' + cmd + '"')
except KeyboardInterrupt:
	pass
