/*
**  TextView.m, implementation of scrolling text stuff for TextLab.
**  Copyright 1989 NeXT, Inc.  All Rights Reserved.
**  Author: Bruce Blumberg
**
**  You may freely copy, distribute and reuse the code in this example.
**  NeXT disclaims any warranty of any kind, expressed or implied, as to
**  its fitness for any particular use.
*/


#import <appkit/appkit.h>
#import "TextView.h"

@implementation TextView:ScrollView

- initFrame:(const NXRect *)frameRect
{
    NXRect rect = {0.0, 0.0, 0.0, 0.0};
	
    /* initialize view */
    [super initFrame:frameRect];
    
    /* specify scrollbars */
    [[self setVertScrollerRequired:YES] setHorizScrollerRequired:NO];

    [self getContentSize:&(rect.size)];
    theText = [self newText:&rect];
    [self setDocView:theText];
    [theText setSel:0 :0];	
    
    // The following two lines allow the resizing of the scrollview
    // to be passed down to the docView (in this case, the text view 
    // itself).

    [contentView setAutoresizeSubviews:YES];
    [contentView setAutosizing:NX_HEIGHTSIZABLE | NX_WIDTHSIZABLE];

    // Create enclosing window and bring it upfront
    [self makeEnclosingWindow:frameRect];
    [[[window setTitle:"Untitled"] display] makeKeyAndOrderFront:self];
    	
    return self;
}

- makeEnclosingWindow:(const NXRect *)rect
{
    textWindow = [[Window alloc] initContent:rect
				 style:NX_TITLEDSTYLE
				 backing:NX_BUFFERED
				 buttonMask:NX_ALLBUTTONS
				 defer:NO];
    [textWindow setContentView:self];
    [textWindow setBackgroundGray:NX_WHITE];
    [textWindow setFreeWhenClosed:YES];
    
    return self;
}
    
- newText:(const NXRect *)frameRect
{
    id	text;
    NXSize aSize = {1.0E38, 1.0E38};
    
    text = [[Text alloc] initFrame:frameRect
    			 text:NULL
			 alignment:NX_LEFTALIGNED];
    [text setOpaque:YES];
    [[[[[text notifyAncestorWhenFrameChanged:YES]
				setVertResizable:YES]
				    setHorizResizable:NO]
					setMonoFont:NO]
					    setDelegate:self];
    
    [text setMinSize:&(frameRect->size)];
    [text setMaxSize:&aSize];
    [text setAutosizing:NX_HEIGHTSIZABLE | NX_WIDTHSIZABLE];
    
    [text setCharFilter:NXEditorFilter];
    return text;
}

- (int) textLength {

  return [theText textLength];
}

- replaceSel: (char *) words {

  [theText replaceSel:words];
  return self;
}

- setSel: (int) alen : (int) blen {

  [theText setSel:alen :blen];
  return self;
}

- setTitle: (char *) theTitle {

  [textWindow setTitle:theTitle];
  return self;
}


@end
