#import <objc/Object.h>
#import <stdlib.h>
#import <stdio.h>
#import <zone.h>
#import <mach.h>
#import <math.h>
#import <ctype.h>
#import <sound/sound.h>
#import <appkit/appkit.h>
#import <appkit/NXBitmapImageRep.h>
#import <appkit/graphics.h>
#import <strings.h>
#import "TextView.h"
#import "space.h"
#import "rand.h"

#define Max_Table_Size 131073
#define Bytes_Per_Pixel 3
#define Max_Harm 128
#define Max_Osc_Size 1048576
#define Default_Osc_Size 16384

#define IDLE 1
#define RUNNING 2
#define PAUSED 3
#define DYING 4


typedef struct {
  int           elms;
  float         *data;
} Tabl;

typedef struct {
  float		min;
  float		max;
} Extrema;

typedef struct _Posit {
  float	location;
  int	delay0;
  int	delay1;
} Posit;

@interface HyperupicGen : Object
{

  int			status,
			N,
			x,y,
			xstart,xend,
			ystart,yend,
			freqstart,freqend,
			maxdelay,
			timedim,		// iteration var for time axis
			timeinc,		// time increment friend of --^
			maxtime,		// time dimension var
			maxdur,			// duration var
			datainc,		// data size scaled time var
			freqdim,		// iteration var for freq axis
			interp,			// time interpolation value
			sndInd,			// table input index
			seed,
			tablesize,
			soundPoint,
			amplPoint;
  float 		pi,
			twopi,
			srate,
			safefreqcon,
			freqcon,
			freqdiff,
			synt,
			howfar,
			bigee,
			duration,
			freqdelay,
			delcon,
			delband,
			leftspan,
			rightspan,
			sample,
			*table,
			*freqs,
			*channel;
  double		ampref,
			ampscale;
  short			*soundData;
  char			imageFile[1024],
			soundFile[1024],
			mapFile[1024],
			tableFile[1024],
			harmsText[8192],
  			*sndData;
  unsigned char		*pictdata;
  id			pict,
			freqDisplay,
			openReq,		// OpenPanel for open requests 
			openMapReq,		// OpenPanel for func requests 
			openTableReq,		// OpenPanel for func requests 
			saveReq;		// SavePanel for save requests
  BOOL			gotImage,
			gotMapFile,
			gotTableFile,
			oscilTable,
			savedSoundFile,
			gotSoundFileName,
			oscInit,
			adjusted,
			isStereo,
			freqAdjust;
  SEL			mapper,
			dimension,
			display,
			coordinate,
			spread,
			minmax,
			osctable,
			oscillator,
			writeMethod,
			pack,
			channels;
  SNDSoundStruct	*sfh;
  NXZone		*ozone,
			*funzone;
  Tabl			output,
			mapFunk,
			harms,
			oscTable;
  Extrema		mm;
  Posit			*pos;
  port_t 		appToObjPort;

}

+ create;
- init;
- (int) getStatus;
- (float) getBigee;
- (float) getDuration;
- (float) getFreqcon;
- snuff;
- pause;
- resume;
- (int) xval;
- (int) yval;
- (int) xstartVal;
- (int) ystartVal;
- (int) xendVal;
- (int) yendVal;
- setxVal: sender;
- setyVal: sender;
- setxstartVal: sender;
- setystartVal: sender;
- setxendVal: sender;
- setyendVal: sender;
- _waitForMessage;
- (float) checkAmp;
- (BOOL) getGotImage;
- (BOOL) getGotMapFile;
- (BOOL) getGotTableFile;
- (BOOL) getSavedSoundFile;
- (BOOL) getIsStereo;
- (BOOL) getOscilTable;
- toggleFreqAdjust: sender;
- displayFreqs: sender;
- displayAll;
- displayMinMax;
- setHarmsText: sender;
- setFreqDelay: sender;
- setDelCon: sender;
- setDelBand: sender;
- setRightSpan: sender;
- setLeftSpan: sender;
- setXcoor;
- setYcoor;
- checkCoordinates;
- checkPictBound;
- checkFreqDist;
- mmHarmSeries;
- mmScale;
- mmHarmSeriesAdjust;
- mmScaleAdjust;
- openImage;
- openMapFile;
- openTableFile;
- monoAcquire;
- stereoAcquire;
- shortPack;
- floatPack;
- (char *) getImagePath;
- (char *) getMapPath;
- (char *) getTablePath;
- (char *) getSoundPath;
- setImagePath: sender;
- setMapPath: sender;
- setTablePath: sender;
- reverseMapping: sender;
- (float) adjustFrequency;
- allocSound;
- writeSound;
- playSound: sender;
- stopPlaying: sender;
- setDefaults;
- allocateDataspace;
- (float) howFar;
- ampref: sender;
- time: sender;
- samplingRate: sender;
- freqcon: sender;
- freqdiff: sender;
- setSeed: sender;
- setSynt: sender;
- runGen;
- selectGenHarmSeries: sender;
- selectGenScale: sender;
- selectXcoor: sender;
- selectYcoor: sender;
- genHarmSeries;
- genScale;
- genHarmSeriesAdjust;
- genScaleAdjust;
- genDiffusion;
- selectDisplayAll: sender;
- selectDisplayMinMax: sender;
- selectGenNorm: sender;
- selectGenRetro: sender;
- selectGenRotNorm: sender;
- selectGenRotRetro: sender;
- selectGenNormInv: sender;
- selectGenRotNormInv: sender;
- selectGenRetroInv: sender;
- selectGenRotRetroInv: sender;
- selectOscCos: sender;
- selectOscComplex: sender;
- selectOscTable: sender;
- setOscCos;
- setOscComplex;
- setOscTable;
- genNorm;
- genRetro;
- genRotNorm;
- genRotRetro;
- genNormInv;
- genRotNormInv;
- genRetroInv;
- genRotRetroInv;
- openMapRequest:sender;
- openTableRequest:sender;
- openRequest:sender;
- saveRequest:sender;
- saveInRequest:sender;
- selectMapR: sender;
- selectMapG: sender;
- selectMapB: sender;
- selectMapRG: sender;
- selectMapRB: sender;
- selectMapGB: sender;
- selectMapRGB: sender;
- mapR;
- mapG;
- mapB;
- mapRG;
- mapRB;
- mapGB;
- mapRGB;
- oscbank;
- writeoutput;

@end

