#import "HyperupicControl.h"


@implementation HyperupicControl

static any_t runFunc(any_t obj)
{
  [((id)obj) runGen];
  return 0;
}

static DPSTimedEntryProc updateStatus( DPSTimedEntry te, double now,
    void *userData )
{
  HyperupicControl *self;

  self = userData;
  if (self->hypeGen) {
    if ([self->hypeGen getStatus] == IDLE) {
      [self->statusText setStringValue:"done"];

      if ( [self->hypeGen getSavedSoundFile] == NO ) {
	char msg[1024];
	if ( [self->hypeGen getIsStereo] == YES ) {
	  sprintf(msg,"%7f", (float) ([self->hypeGen checkAmp] ));
	  [self->amplitudeText setStringValue:msg];
	}
	else {
	  sprintf(msg,"%7f", (float) ([self->hypeGen getBigee] ));
	  [self->amplitudeText setStringValue:msg];
	}
	sprintf(msg,"%7f", (float) ([self->hypeGen getDuration] ));
	[self->durationText setStringValue:msg];
      }
    }
    else {
      if ([self->hypeGen getStatus] == PAUSED)
	[self->statusText setStringValue:"paused"];
      else {
	char msg[1024];
	sprintf(msg,"%d%% computed", (int) ([self->hypeGen howFar] * 100.));
	[self->statusText setStringValue:msg];

	if ( [self->hypeGen getIsStereo] == YES ) {
	  sprintf(msg,"%7f", (float) ([self->hypeGen checkAmp] ));
	  [self->amplitudeText setStringValue:msg];
	}
	else {
	  sprintf(msg,"%7f", (float) ([self->hypeGen getBigee] ));
	  [self->amplitudeText setStringValue:msg];
	}
	sprintf(msg,"%7f", (float) ([self->hypeGen getDuration] ));
	[self->durationText setStringValue:msg];
      }
    }
  }
  return 0;
}

+ create {

  id	newInstance;

  newInstance = [self new];
  return newInstance;
}

- init {

  [super init];
  hypeGen = [[HyperupicGen alloc] init];
  myTimedEntry = DPSAddTimedEntry( 3.0, (DPSTimedEntryProc) updateStatus,
		self, NX_BASETHRESHOLD );
  whichTabl = 0;
  whichStereo = 0;

  return self;
}

- sendAmplitudeText: (char *) stringValue {

  [amplitudeText setStringValue:stringValue];
  return self;
}

- sendStatusText: (char *) stringValue {

  [statusText setStringValue:stringValue];
  return self;
}

- sendMapPathText: (char *) stringValue{

  [mapPathText setStringValue:stringValue];
  return self;
}

- sendImagePathText: (char *) stringValue{

  [imagePathText setStringValue:stringValue];
  return self;
}

- displayFreqs: sender {

  [freqConWindow orderBack:sender];
  [hypeGen displayFreqs:sender];
  [self updateFields];

  return self;
}

- displayImage: sender {

  int		x,y;
  static NXRect	wRect = {{80.0, 80.0},{0.0,0.0}};
  char		*path;

  if ( [hypeGen getGotImage] == NO ) {
    NXRunAlertPanel("Needles, California","Christ Almighty! No image loaded!",
		    "okie",NULL,NULL,NULL);
    return nil;
  }

/*
  if (imageView != nil)
    [imageView free];

  if (imageScroll != nil)
    [imageScroll free];
*/

  x = [hypeGen xval];
  y = [hypeGen yval];
  wRect.size.height = y + 20;
  wRect.size.width = x + 20;

  if ( wRect.size.height > 800 )
    wRect.size.height = 800;

  if ( wRect.size.width > 800 )
    wRect.size.width = 800;

  path = [hypeGen getImagePath];

  imageView = [[TiffDocView alloc] init];
  [imageView readImageFile:path];

  path = rindex( path, '/' );
  if (*path = '/')
    path++;

  imageScroll = [[ImageScrollView alloc] initFrame:&wRect];
  [[imageScroll window] setDelegate:self];
  [imageScroll setDocView:imageView];
  [imageScroll setTitle:path];

  if ( (wRect.origin.x < 20.0) || (wRect.origin.y < 20.0) ) {
    wRect.origin.x = 120.0;
    wRect.origin.y = 100.0;
  }
  else
    NXOffsetRect(&wRect, 20.0, -20.0);

  return self;
}


- setHarmsText: sender {

  [hypeGen setHarmsText:sender];
  return self;
}

- setxVal: sender {

  char	bonk[1024];

  [hypeGen setxVal:sender];
  sprintf(bonk,"%d", [hypeGen xendVal]);
  [xfText setStringValue:bonk];
  sprintf(bonk,"%d", 0);
  [xsText setStringValue:bonk];

  return self;
}

- setyVal: sender {

  char	bonk[1024];

  [hypeGen setyVal:sender];
  sprintf(bonk,"%d", [hypeGen yendVal]);
  [yfText setStringValue:bonk];
  sprintf(bonk,"%d", 0);
  [ysText setStringValue:bonk];

  return self;
}

- setxstartVal: sender {

  [hypeGen setxstartVal:sender];
  return self;
}

- setystartVal: sender {

  [hypeGen setystartVal:sender];
  return self;
}

- setxendVal: sender {

  [hypeGen setxendVal:sender];
  return self;
}

- setyendVal: sender {

  [hypeGen setyendVal:sender];
  return self;
}

- snuff: sender {

  if ([hypeGen getStatus] != IDLE) {
	[hypeGen snuff];
	[statusText setStringValue:"snuffed"];
  }
  else 
    NXRunAlertPanel("Shake your Booty","Holy Toledo! Nothing left to kill!",
		    "okie",NULL,NULL,NULL);

  return self;
}

- pause: sender {

  if ([hypeGen getStatus] == PAUSED) {
    [(HyperupicGen *)hypeGen resume];
    [statusText setStringValue:"running"];
  }
  else {
    if ([hypeGen getStatus] != IDLE) {
  	[(HyperupicGen *)hypeGen pause];
	[statusText setStringValue:"paused"];
    }
    else {
  	NXRunAlertPanel("Head Cheese","Look around you! We're idling.",
			"dokie",NULL,NULL,NULL);
//	[sender setState:0];
    }
  }

  return self;
}

- ampref: sender {
  [hypeGen ampref:sender];
  return self;
}

- time: sender {

  [hypeGen time:sender];
  return self;
}

- freqcon: sender {
  [hypeGen freqcon:sender];
  return self;
}

- freqdiff: sender {
  [hypeGen freqdiff:sender];
  return self;
}

- samplingRate: sender {
  [hypeGen samplingRate:sender];
  return self;
}

- setSynt: sender {
  [hypeGen setSynt:sender];
  return self;
}

- setSeed: sender {
  [hypeGen setSeed:sender];
  return self;
}

- setFreqDelay: sender {

  [hypeGen setFreqDelay:sender];
  return self;
}

- setDelCon: sender {

  [hypeGen setDelCon:sender];
  return self;
}

- setDelBand: sender {

  [hypeGen setDelBand:sender];
  return self;
}

- setLeftSpan: sender {

  [hypeGen setLeftSpan:sender];
  return self;
}

- setRightSpan: sender {

  [hypeGen setRightSpan:sender];
  return self;
}

- setImagePath: sender {

  char	bonk[1024];

  if ( [hypeGen getStatus] == IDLE ) {
    [hypeGen setImagePath:sender];
    if ( [hypeGen getGotImage] == YES) {
      sprintf(bonk,"%d", [hypeGen xval]);
      [xText setStringValue:bonk];
      sprintf(bonk,"%d", [hypeGen yval]);
      [yText setStringValue:bonk];
      sprintf(bonk,"%d", [hypeGen xendVal]);
      [xfText setStringValue:bonk];
      sprintf(bonk,"%d", [hypeGen yendVal]);
      [yfText setStringValue:bonk];
      sprintf(bonk,"%d", 0);
      [xsText setStringValue:bonk];
      sprintf(bonk,"%d", 0);
      [ysText setStringValue:bonk];
    }
  }
  else {
    sprintf(bonk,"%s", [hypeGen getImagePath]);
    [imagePathText setStringValue:bonk];
  }

  return self;
}

- setMapPath: sender {

  char	bonk[1024];

  if ( [hypeGen getStatus] != IDLE ) {
    sprintf(bonk,"%s", [hypeGen getMapPath]);
    [mapPathText setStringValue:bonk];
  }
  else 
    [hypeGen setMapPath:sender];

  return self;
}

- setTablePath: sender {

  char	bonk[1024];

  if ( [hypeGen getStatus] != IDLE ) {
    sprintf(bonk,"%s", [hypeGen getTablePath]);
    [tablePathText setStringValue:bonk];
  }
  else
    [hypeGen setTablePath:sender];

  return self;
}

- openRequest:sender
{

  char	bonk[1024];

  if ( [hypeGen getStatus] != IDLE ) {
    NXRunAlertPanel("Iron Maiden",
		    "Well blow me down! Hyperupic is transducing!",
                        "okie",NULL,NULL,NULL);
    return nil;
  }

  if ([hypeGen openRequest:sender] && [hypeGen getGotImage] == YES) {
    sprintf(bonk,"%s", [hypeGen getImagePath]);
    [imagePathText setStringValue:bonk];
    sprintf(bonk,"%d", [hypeGen xval]);
    [xText setStringValue:bonk];
    sprintf(bonk,"%d", [hypeGen yval]);
    [yText setStringValue:bonk];
    sprintf(bonk,"%d", [hypeGen xendVal]);
    [xfText setStringValue:bonk];
    sprintf(bonk,"%d", [hypeGen yendVal]);
    [yfText setStringValue:bonk];
    sprintf(bonk,"%d", 0);
    [xsText setStringValue:bonk];
    sprintf(bonk,"%d", 0);
    [ysText setStringValue:bonk];
  }

  return self;
}

- openMapRequest:sender
{

  char	bonk[1024];

  if ( [hypeGen getStatus] != IDLE ) {
    NXRunAlertPanel("Don Ho","NO NO NO! Hyperupic is transducing!",
                        "dokie",NULL,NULL,NULL);
    return nil;
  }

  if ([hypeGen openMapRequest:sender] && [hypeGen getGotMapFile] == YES) {
    sprintf(bonk,"%s", [hypeGen getMapPath]);
    [mapPathText setStringValue:bonk];
  }

  return self;
}

- openTableRequest:sender
{

  char	bonk[1024];

  if ( [hypeGen getStatus] != IDLE ) {
    NXRunAlertPanel("Psychedelic Circus","Uh Oh! Hyperupic is transducing!",
                        "dokie",NULL,NULL,NULL);
    return nil;
  }

  if ([hypeGen openTableRequest:sender] && [hypeGen getGotTableFile] == YES) {
    sprintf(bonk,"%s", [hypeGen getTablePath]);
    [tablePathText setStringValue:bonk];
    sprintf(bonk,"%f", [hypeGen getFreqcon]);
    [freqOffText setStringValue:bonk];
  }

  return self;
}


- saveRequest:sender
{
  [hypeGen saveRequest:sender];
  return self;
}

- saveInRequest:sender
{
  if ([hypeGen saveInRequest:sender])
    [mainWindow setTitle:[hypeGen getSoundPath]];

  return self;
}

- playSound: sender {

  [hypeGen playSound:sender];
  return self;
}

- stopPlaying: sender {

  SNDStop(1);
  return self;
}

- reverseMapping: sender {

  [hypeGen reverseMapping:sender];
  return self;
}

- adjustFrequency: sender {

  char	bonk[1024];

  sprintf(bonk,"%f", [hypeGen adjustFrequency]);
  [freqOffText setStringValue:bonk];
  return self;
}

- runGen: sender {

  int	grabber;

  if ([hypeGen getGotImage] == NO) {
    NXRunAlertPanel("Bruno Walter","Criminy! No image to transduce!",
                        "dokie",NULL,NULL,NULL);
    return nil;
  }

  if ([hypeGen getGotMapFile] == NO) {
    NXRunAlertPanel("Liberal, Kansas","Loser! Specify an amplitude map file!",
                        "okie",NULL,NULL,NULL);
    return nil;
  }

  if ([hypeGen getOscilTable] == YES) {
    if ([hypeGen getGotTableFile] == NO) {
      NXRunAlertPanel("Lead Pipe",
		    "Oh Ford! You need to specify an oscillator table!",
		    "dokie",NULL,NULL,NULL);
      return nil;
    }
  }

  [hypeGen checkPictBound];
  [hypeGen checkCoordinates];
  if ( ![hypeGen checkFreqDist] )
    return nil;
  [self updateFields];

  // thread control

  if ([hypeGen getStatus] != IDLE) {
    grabber = NXRunAlertPanel("Snail Death",
		"Drunkard! You already have a process running!",
		"Snuff","Reprieve",NULL,NULL);
    if (grabber == NX_ALERTDEFAULT) {
      [self snuff:self];
      cthread_yield(); 			// a good time for a thread!
    } 
    else {
      if (grabber == NX_ALERTALTERNATE)
        return nil;
    }
  }


  if ( [hypeGen getSavedSoundFile] == NO ) {
    grabber = NXRunAlertPanel("Marlboro","Clumsy! Unsaved sound file!",
		    "Save","Forget","Cancel",NULL);

    if ( grabber == NX_ALERTDEFAULT )
      [self saveInRequest:self];
    else {
      if ( grabber == NX_ALERTOTHER )
	return nil;
    }
  }

  cthread_detach(cthread_fork( runFunc, (any_t) hypeGen));

  return self;
}

- updateFields {

  char	bonk[128];

  sprintf(bonk,"%d", [hypeGen xval]);
  [xText setStringValue:bonk];
  sprintf(bonk,"%d", [hypeGen yval]);
  [yText setStringValue:bonk];
  sprintf(bonk,"%d", [hypeGen xendVal]);
  [xfText setStringValue:bonk];
  sprintf(bonk,"%d", [hypeGen yendVal]);
  [yfText setStringValue:bonk];
  sprintf(bonk,"%d", [hypeGen xstartVal]);
  [xsText setStringValue:bonk];
  sprintf(bonk,"%d", [hypeGen ystartVal]);
  [ysText setStringValue:bonk];
  
  return self;
}

- selectGenHarmSeries: sender {

  [hypeGen selectGenHarmSeries:sender];
  return self;
}

- selectGenScale: sender {

  [hypeGen selectGenScale:sender];
  return self;
}

- selectXcoor: sender {

  [hypeGen selectXcoor:sender];
  return self;
}


- selectYcoor: sender {

  [hypeGen selectYcoor:sender];
  return self;
}

- toggleFreqAdjust: sender {

  [hypeGen toggleFreqAdjust:sender];
  return self;
}

- selectDisplayAll: sender {

  [hypeGen selectDisplayAll:sender];
  return self;
}

- selectDisplayMinMax: sender {

  [hypeGen selectDisplayMinMax:sender];
  return self;
}


- selectGenNorm: sender {

  [hypeGen selectGenNorm:sender];
  return self;
}

- selectGenRetro: sender {

  [hypeGen selectGenRetro:sender];
  return self;
}

- selectGenRotNorm: sender {

  [hypeGen selectGenRotNorm:sender];
  return self;
}

- selectGenRotRetro: sender {

  [hypeGen selectGenRotRetro:sender];
  return self;
}

- selectGenNormInv: sender {

  [hypeGen selectGenNormInv:sender];
  return self;
}

- selectGenRetroInv: sender {

  [hypeGen selectGenRetroInv:sender];
  return self;
}

- selectGenRotNormInv: sender {

  [hypeGen selectGenRotNormInv:sender];
  return self;
}

- selectGenRotRetroInv: sender {

  [hypeGen selectGenRotRetroInv:sender];
  return self;
}

- selectMapR: sender {

  [hypeGen selectMapR:sender];
  return self;
}

- selectMapG: sender {

  [hypeGen selectMapG:sender];
  return self;
}

- selectMapB: sender {

  [hypeGen selectMapB:sender];
  return self;
}

- selectMapRG: sender {

  [hypeGen selectMapRG:sender];
  return self;
}

- selectMapRB: sender {

  [hypeGen selectMapRB:sender];
  return self;
}

- selectMapGB: sender {

  [hypeGen selectMapGB:sender];
  return self;
}

- selectMapRGB: sender {

  [hypeGen selectMapRGB:sender];
  return self;
}

// consider enum for the whichTabl and whichStereo junior selectors

- selectOscCos: sender {

  if ( [hypeGen getStatus] != IDLE )
    [matrixTableField selectCellAt:whichTabl:0];

  else {
    [hypeGen selectOscCos:sender];
    whichTabl = 0;
  }

  return self;
}

- selectOscComplex: sender {

  if ( [hypeGen getStatus] != IDLE )
    [matrixTableField selectCellAt:whichTabl:0];

  else {
    [harmWindow orderBack:sender];
    [hypeGen selectOscComplex:sender];
    whichTabl = 1;
  }

  return self;
}

- selectOscTable: sender {

  if ( [hypeGen getStatus] != IDLE )
      [matrixTableField selectCellAt:whichTabl:0];

  else {
    if (![self openTableRequest:sender])	
      return nil;

    if (![hypeGen selectOscTable:sender])
      return nil;

    whichTabl = 2;
  }

  return self;
}

- selectOscBank: sender {

  if ( [hypeGen getStatus] != IDLE )
    [stereoField selectCellAt:whichStereo:0];

  else {
    [hypeGen selectOscBank:sender];
    whichStereo = 0;
  }

  return self;
}

- selectOscStereo: sender {

  if ( [hypeGen getStatus] != IDLE )
      [stereoField selectCellAt:whichStereo:0];

  else {
    [hypeGen selectOscStereo:sender];
    whichStereo = 1;
  }

  return self;
}

@end
