#import <objc/Object.h>
#import <stdlib.h>
#import <stdio.h>
#import <mach.h>
#import <cthreads.h>
#import <sound/sound.h>
#import <appkit/appkit.h>
#import <appkit/Window.h>
#import <appkit/Matrix.h>
#import <appkit/FormCell.h>
#import "ImageScrollView.h"
#import "TiffDocView.h"
#import "HyperupicGen.h"

@interface HyperupicControl : Object
{

  int		whichStereo,
		whichTabl;
  id		hypeGen,			// HyperupicGen instance
		xText,
		yText,
		xsText,
		xfText,
		ysText,
		yfText,
		durationText,
		mapPathText,
		imagePathText,
		tablePathText,
		amplitudeText,
    		statusText,
		freqConWindow,
		harmWindow,
		oscilWindow,
		mainWindow,
		oscilRadio,
		freqOffText,
		imageScroll,
		imageView,
		stereoField,
		matrixTableField;
  DPSTimedEntry	myTimedEntry;
}

+ create;
- init;
- sendAmplitudeText: (char *) stringValue;
- sendStatusText: (char *) stringValue;
- sendMapPathText: (char *) stringValue;
- sendImagePathText: (char *) stringValue;
- setSynt: sender;
- setSeed: sender;
- setImagePath: sender;
- setMapPath: sender;
- setTablePath: sender;
- setxVal: sender;
- setyVal: sender;
- setFreqDelay: sender;
- setDelCon: sender;
- setDelBand: sender;
- setLeftSpan: sender;
- setRightSpan: sender;
- selectYcoor: sender;
- selectXcoor: sender;
- toggleFreqAdjust: sender;
- pause: sender;
- snuff: sender;
- reverseMapping: sender;
- displayFreqs:sender;
- displayImage:sender;
- updateFields;
- adjustFrequency:sender;
- playSound: sender;
- stopPlaying: sender;
- ampref: sender;
- time: sender;
- samplingRate: sender;
- freqcon: sender;
- freqdiff: sender;
- runGen: sender;
- selectGenHarmSeries: sender;
- selectGenScale: sender;
- selectDisplayAll: sender;
- selectDisplayMinMax: sender;
- selectGenNorm: sender;
- selectGenRetro: sender;
- selectGenRotNorm: sender;
- selectGenRotRetro: sender;
- selectGenNormInv: sender;
- selectGenRetroInv: sender;
- selectGenRotNormInv: sender;
- selectGenRotRetroInv: sender;
- selectOscCos: sender;
- selectOscComplex: sender;
- selectOscTable: sender;
- openMapRequest:sender;
- openTableRequest:sender;
- openRequest:sender;
- saveRequest:sender;
- saveInRequest:sender;
- selectMapR: sender;
- selectMapG: sender;
- selectMapB: sender;
- selectMapRG: sender;
- selectMapRB: sender;
- selectMapGB: sender;
- selectMapRGB: sender;

@end

