
#import <objc/Object.h>
#import <appkit/graphics.h>
#import <sys/param.h>  //for MAXPATHLEN

@interface Help:Object
{
    id helpScrollView;			/* scrollView to put help text in */
    id helpBrowser;			/* NXBrowser of help topics */
    id helpPanel;			/* the help panel */
    char helpDirectory[MAXPATHLEN];	/* the directory to find help files */
    char noHelpFile[MAXPATHLEN];	/* the name of the "no help" file */
}

/* INIT/FREE METHODS */
- init;
- setHelpBrowser:anObject;

/* TARGET/ACTION METHODS */
- generalHelp:sender;
- browserHit:sender;
- print:sender;

/* HELP METHODS */
- showHelpFile:(const char*)filename;
- helpForWindow:window;
- helpForView:view atPoint:(NXPoint *)aPt;
- helpForObject:object;

/* BROWSER DELEGATE METHODS */
- (int)browser:sender fillMatrix:matrix inColumn:(int)column;
- browser:sender loadCell:cell atRow:(int)row inColumn:(int)column;
- (BOOL)browser:sender selectCell:(const char *)title inColumn:(int)column;

/* WINDOW DELEGATE METHODS */
- windowWillResize:sender toSize:(NXSize *)frameSize;

@end
