#import <appkit/appkit.h>
#import "ImageScrollView.h"

@implementation ImageScrollView:ScrollView

- initFrame:(const NXRect *)frameRect
{
    NXRect rect = {0.0, 0.0, 0.0, 0.0};
	
    /* initialize view */
    [super initFrame:frameRect];
    
    /* specify scrollbars */
    [[self setVertScrollerRequired:YES] setHorizScrollerRequired:YES];

    [self getContentSize:&(rect.size)];

    // The following two lines allow the resizing of the scrollview
    // to be passed down to the docView (in this case, the text view 
    // itself).

    [contentView setAutoresizeSubviews:YES];
    [contentView setAutosizing:NX_HEIGHTSIZABLE | NX_WIDTHSIZABLE];

    // Create enclosing window and bring it upfront
    [self makeEnclosingWindow:frameRect];
    [[window display] makeKeyAndOrderFront:self];
    	
    return self;
}

- makeEnclosingWindow:(const NXRect *)rect
{
    imageWindow = [[Window alloc] initContent:rect
				 style:NX_TITLEDSTYLE
				 backing:NX_BUFFERED
				 buttonMask:NX_ALLBUTTONS
				 defer:NO];
    [imageWindow setContentView:self];
    [imageWindow setBackgroundGray:NX_WHITE];
    [imageWindow setFreeWhenClosed:YES];
    
    return self;
}
    
- setTitle: (char *) theTitle {

  [imageWindow setTitle:theTitle];
  return self;
}

@end
