/*
 * This subclass only adds a few responsibilities to the Application class.
 * It loads the info and preferences panels on demand, keeps track of the 
 * path to the app wrapper, and overrides sendEvent: to watch for 
 * control-mouseDown events which it vectors off to the help object.
 *
 * Author: Julie Zelenski, NeXT Developer Support  (Thanks Julie!)
 * You may freely copy, distribute and reuse the code in this example.  
 * NeXT disclaims any warranty of any kind, expressed or implied, as to 
 * its fitness for any particular use.
 */


#import "HyperupicApp.h"
#import "Help.h"
#import <appkit/View.h>
#import <strings.h>
#import <appkit/defaults.h>  	// for NXArgv
#import <libc.h>		// for chdir, getwd


@implementation HyperupicApp:Application

+ new;
/* New is overridden so the BusyBoxApp gets and saves the path to executable.
 * The help object will ask the app for this, so it can find the help
 * files which are in a directory in the app wrapper. 
 */
{
    char *suffix;
    
    self = [super new];
    strcpy(appDirectory, NXArgv[0]);
    if (suffix = rindex(appDirectory,'/')) 
        *suffix  = '\0';			// remove executable name
    if (appDirectory) chdir(appDirectory); 
    getwd(appDirectory);
    return self;
}


- (const char *)appDirectory;
/* Returns the path to the app wrapper (for Help object).
 */
{
    return appDirectory;
}


- preferences:sender
/*
 * The preferences panel is a separate nib module and only loaded on demand.
 */
{
    if (!prefPanel)
       prefPanel=[self loadNibSection:"PrefPanel.nib" owner:self withNames:NO];
    [prefPanel orderFront:self];
    return self;
}

@end
