VCOMBI  MACRO  OUT,IN,RATE,PDEL,nnn,iscl
; Written by Keith Lent, University of Texas, 1988
;   A INTERPOLATING VARIABLE DELAY COMB FILTER
;       nnn SHOULD BE AN EVEN #
;       AND PDEL IS A REAL # CONTAINING THE PERCENT DELAY
        ORG     YH:
_BUFF   DSM     nnn
        ORG     X:
_PTR    DC      _BUFF
        ORG     P:
        MOVE    Y:(PDEL),B
        ABS     B       X:(_PTR),R4
        MOVE    #>(nnn),X0      B,Y0
        MPY     Y0,X0,A         Y:(RATE),Y1
        MOVE    A1,N4
        MOVEC   #(nnn-1),M4
        CLR     A       A0,X0
        OR      X0,A    Y:(R4+N4),B
        LSR     A       (R4)-
        MOVE    A,X0    Y:(R4+N4),Y0
        SUB     Y0,B    R4,X:(_PTR)
        TFR     Y0,A    B,Y0
        MACR    X0,Y0,A         Y:(IN),B

        IF      (iscl==1)
                SUB     B,A
        ENDIF
        MOVE    A,X1
        MACR    X1,Y1,B
        MOVE    B,Y:(R4)
        MOVE    B,Y:(OUT)
        ENDM
