MIDIP3    MACRO   P1,V1,P2,V2,P3,V3,PWHEEL,MWHEEL,PROGNUM  ;THE MIDI HANDLER
; Written by Keith Lent, University of Texas, 1988
        ORG     X:
; STORE JUMP LOCATIONS FOR EACH 4-BIT MIDI STATUS VALUE
_DUMMY  SET     @LCV(L)         ;REMEMBER OLD LOCATION
        ORG X:$0
        DC      _M_STAT         ;0
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _NOTE_OFF       ;8
        DC      _NOTE_ON        ;9
        DC      _M_STAT         ;A
        DC      _M_WHEEL        ;B
        DC      _P_NUMB         ;C
        DC      _M_STAT         ;D
        DC      _P_WHEEL        ;E
        DC      _M_STAT         ;F
        ORG     X:_DUMMY        ;REPLACE POINTER
        ORG     Y:
_TEMP   DC      0               ;TEMP STORAGE FOR MSB/LSB HOLDER
        ORG     P:
                                ;CHECK FOR MIDI DATA
_JMPLOC JSET    #2,X:$FFF1,>_M_STAT
        JMP     _END
_M_STAT
        MOVEP   X:$FFF4,X0
        CLR     B               #$08,X1    ;SHIFT 4-BITS CONSTANT
        MPY     X1,X0,A         #$F8,B1
        CMP     X0,B            A1,R0      ;AVOID REAL TIME MESSAGE
        JLE     _END
        MOVE    X:(R0),X0
        MOVEM   X0,P:(_JMPLOC+1)
        JMP     _END

_NOTE_OFF
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVEP   X:$FFF6,Y:(_TEMP)       ;GET PITCH BYTE (HIGH BITS)
        MOVE    #_VEL_OFF,A0             ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_VEL_OFF
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        CLR     B       #_NOTE_OFF,A0   ;SET VELOCITY =0
                                        ;and SET NEXT PTR to note off
        JMP     _VEL_ON2

_NOTE_ON
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVEP   X:$FFF6,Y:(_TEMP)       ;GET PITCH BYTE (HIGH BITS)
        MOVE    #_VEL_ON,A0             ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_VEL_ON
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVE    X:$FFF6,B               ;GET VELOCITY BYTE (HIGH BITS)
        MOVE    #_NOTE_ON,A0            ;SET NEXT POINTER
_VEL_ON2
        MOVEM   A0,P:(_JMPLOC+1)        ;STORE NEXT BYTE PTR
        MOVE    Y:(_TEMP),Y0            ;GET PITCH VALUE
        TST     B       Y:(V1),A   B,X0
        JEQ     _LOFF                   ;JMP IF NOTE OFF MESSAGE
_LON1   TST     A       Y:(V2),B
        JNE     _LON2                   ;IF CHANNEL IS FREE
          MOVE  Y0,Y:(P1)               ;SET THE NOTE ON
          MOVE  X0,Y:(V1)
          JMP     _VEND
_LON2   TST     B       Y:(V3),A
        JNE     _LON3                   ;IF CHANNEL IS FREE
          MOVE  Y0,Y:(P2)               ;SET THE NOTE ON
          MOVE  X0,Y:(V2)
          JMP     _VEND
_LON3   TST     A
;       JNE     _VEND                   ;set the note here unconditionaly
          MOVE  Y0,Y:(P3)
          MOVE  X0,Y:(V3)
          JMP     _VEND
_LOFF
        MOVE    Y:(P1),A
_LOFF1  CMP     Y0,A    Y:(P2),B
        JNE     _LOFF2                  ;IF CHANNEL IS PLAYING THE NOTE
          MOVE  X0,Y:(V1)                ;SET THE NOTE OFF
          JMP     _VEND
_LOFF2  CMP     Y0,B    Y:(P3),A
        JNE     _LOFF3                  ;IF CHANNEL IS PLAYING THE NOTE
          MOVE  X0,Y:(V2)                ;SET THE NOTE OFF
          JMP     _VEND
_LOFF3  CMP     Y0,A
        JNE     _VEND                   ;IF CHANNEL IS PLAYING THE NOTE
          MOVE  X0,Y:(V3)                ;SET THE NOTE OFF
;         JMP     _VEND
_VEND
        JMP     _END
_P_WHEEL
        JSET    #7,X:$FFF4,_M_STAT      ;NO MORE DATA
;
        MOVEP   X:$FFF5,A               ;GET LSB P.WHEEL BYTE
        LSL     A       #$C0,X0
        ADD     X0,A
        MOVE    A,Y:(_TEMP)
        MOVE    #_PW_MSB,A0             ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_PW_MSB
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVE    Y:(_TEMP),A
        MOVE    X:$FFF6,X0
        ADD     X0,A
        MOVE    A,Y:(PWHEEL)
        MOVE    #_P_WHEEL,A0            ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_M_WHEEL
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
;
        MOVEP   X:$FFF6,A               ;GET CONTROL #
        MOVE    #$01,X0
        CMP     X0,A
        JEQ     _MWH2                   ;IF MSB OF MOD. WHEEL
        MOVE    #_M_STAT,A0             ;OTHERWISE SKIP IT
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_MWH2
        MOVE    #_MW_MSB,A0             ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_MW_MSB
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVEP   X:$FFF6,Y:(MWHEEL)      ;GET VALUE (HIGH BITS)
        MOVE    #_M_WHEEL,A0            ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_P_NUMB
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVEP   X:$FFF6,A               ;GET NEW PROGRAM NUMBER
        MOVE    A,Y:(PROGNUM)
        JMP     _END

_END
        ENDM
