       opt     nocex,nocl,nocm,nomd,mu
HEADER  MACRO   S_R,IOLEN,IOLOC
; Written by Keith Lent, University of Texas, 1988
; **********************
; SETUP GLOBAL VARIABLES
S_RATE  EQU     S_R
IOBufLen     EQU     IOLEN
IOBufLoc     EQU     IOLOC

; **********************
; START REAL SPACE AT Y:$0
        ORG Y:$0
        ORG YL:$80
        ORG YH:$2000   ;************
        ORG X:$10       ;SKIP OVER THE POSSIBLE MIDI POINTERS
        ORG XL:$80
        ORG XH:$200
        ORG P:$100
        ORG PH:$20,YH:$3E20
        ORG PL:$0
; **********************
; DO THESE BEFORE OVERLAY
; SETUP INTERNAL ROM ON and SINE WAVE TABLE REGISTERS - R7,M7
        SECTION ROM_ON
        ORG P:
        MOVE    #$06,OMR        ;TURN ON ROM TABLE
        MOVE    #$FF,M7         ;TABLE SIZE IS 256
        ENDSEC
; wait for sync on a channel
        SECTION rl_sync
        ORG P:
here0   jset    #$3,x:$ffe5,here0       ;wait for r/l sync
here1   jclr    #$3,x:$ffe5,here1       ;wait for r/l sync
        ENDSEC
; SETUP INTERUPTS
        SECTION INTS_ON
;        ORG     YL:IOBufLoc
;        DSM   IOBufLen
        ORG P:
        MOVE    #IOBufLoc,R6    ;R6 = INPUT AND OUTPUT POINTER
        MOVE    #IOBufLen-1,M6
        movep   #$3007,x:$ffff  ;ONLY SSI AND IRQA CAN INTERUPT
        andi    #$fc,MR         ;don't mask any ints
        BSET    #14,X:$FFED     ;ALLOW SSI TRANSMIT INTERUPTS
        JMP     $0      ;now copy in real program
        ENDSEC
; *********************  ;THE ssi INTERUPT ROUTINES
        org     p:$10
        MOVEP   Y:(R6),X:$FFEF
        MOVEP   X:$FFEF,Y:(R6)+
        org     p:$12
        MOVEP   Y:(R6),X:$FFEF
        MOVEP   X:$FFEF,Y:(R6)+
; *********************  ;THE PROGRAM OVERLAY COPY ROUTINE
; *********************  ALL OVERLAY CODE SHOULD BE AT org ph:,yh:
        SECTION COPYOVER
        org     p:$0
        MOVE    #$20,R0
        MOVE    #$3E20,R1
        DO      #$200-$20,OD
          MOVE  Y:(R1)+,X0
          MOVEM  X0,P:(R0)+
OD
        JMP     <kBEGIN
        ENDSEC
;********************
; SETUP I/O
;***ASSUME THIS IS OK FROM BOOT***;       ORG P:
;       SECTION I_O             ;FOR DMP7 I/O (SSI) CONTROL REGISTERS
;       RESET                   ;*                           *
;       MOVEP   #$6000,X:$FFEC  ;SET CONTROL REG. A          *
;       MOVEP   #$3308,X:$FFED  ;SET CONTROL REG. B          *
;                               ;FOR MIDI INPUT ONLY (SCI)
;       MOVEP   #$0302,X:$FFF0  ;SET CONTROL REG             *
;       MOVEP   #$0009,X:$FFF2  ;SET CLOCK CONTROL REG.
;       MOVEP   #$1E3,X:$FFE1   ;PORT C CONTROL REG.         *
;       ENDSEC
        ORG     PH:,YH:
kBEGIN
        ENDM
