 /* NXRunAlertPanel("title", "I am here ...", "OK", NULL, NULL);  */

/* Generated by Interface Builder */

#import "deviceInspectorView.h"
#import <appkit/appkit.h>
#import <dpsclient/wraps.h>
#import "Kdevice.h"
#import <objc/hashtable.h>
#include <strings.h>
#define DEVICEOFFSETH 60.0
#define DEVICEOFFSETV 30.0
#define	DOTSIZE 4.0

@implementation deviceInspectorView

id	GrayDotBitmap = nil;
id	BlackDotBitmap = nil;
BOOL	returnCondition;
id	currentDevice=nil	;

int		tempWirePointH[9] = {-999.,-999.,-999.,-999.,80.,-999.,-999.,-999.,-999.};
int		tempWirePointV[9] = { 0,0,0,0,0,0,0,0,0};


BOOL KIsNear(float h1,float v1,float h2,float v2)
{
	float	hdiff;
	float vdiff;
	hdiff = (h1>h2?h1-h2:h2-h1);
	vdiff = (v1>v2?v1-v2:v2-v1);
	return ((hdiff *hdiff+vdiff*vdiff)< (DOTSIZE*DOTSIZE*2.));
}

void KDrawGrayDot(float h,float v)
{
	NXPoint spot;
	if(!GrayDotBitmap)
		GrayDotBitmap = [Bitmap newFromMachO:"GrayDot.tiff"];
	spot.x = h-DOTSIZE; spot.y = v-DOTSIZE;
 	[GrayDotBitmap composite:NX_SOVER toPoint:&spot];
}

void KDrawBlackDot(float h,float v)
{
	NXPoint spot;
	if(!BlackDotBitmap)
		BlackDotBitmap = [Bitmap newFromMachO:"BlackDot.tiff"];
	spot.x = h-DOTSIZE; spot.y = v-DOTSIZE;
 	[BlackDotBitmap composite:NX_SOVER toPoint:&spot];
}

- setSubWire1:anObject
{
    subWire1 = anObject;
    return self;
}

- setDescriptionScrollView:anObject
{
    descriptionScrollView = anObject;
    return self;
}

- setSubWire2:anObject
{
    subWire2 = anObject;
    return self;
}

- setSubWire3:anObject
{
    subWire3 = anObject;
    return self;
}

- setSubWire4:anObject
{
    subWire4 = anObject;
    return self;
}

- setCodeScrollView:anObject
{
    codeScrollView = anObject;
    return self;
}

- setSubWire5:anObject
{
    subWire5 = anObject;
    return self;
}

- setSubWire6:anObject
{
    subWire6 = anObject;
    return self;
}

- setSubWire7:anObject
{
    subWire7 = anObject;
    return self;
}

- setSubWire8:anObject
{
    subWire8 = anObject;
    return self;
}

- setSubWire9:anObject
{
    subWire9 = anObject;
    return self;
}

- OK:sender
{
	int	i,len;
	char	  *string;
	returnCondition = YES;
 	for(i=0;i<9;i++) {
		[currentDevice  setWirePointH:tempWirePointH[i]  number:i];
		[currentDevice  setWirePointV:tempWirePointV[i]  number:i];
	}
	string	= (char *) malloc(len = 1+[[descriptionScrollView docView] textLength]);
	[[descriptionScrollView docView] getSubstring:string  start:0 length:len];
	[currentDevice  setTitle:string];

	string	= (char *) malloc(len = 1+[[codeScrollView docView] textLength]);
	[[codeScrollView docView] getSubstring:string  start:0 length:len];
	[currentDevice  setCode:string];

	[currentDevice  setWireName:NXCopyStringBuffer([subWire1 stringValue])  number:0];
	[currentDevice  setWireName:NXCopyStringBuffer([subWire2 stringValue])  number:1];
	[currentDevice  setWireName:NXCopyStringBuffer([subWire3 stringValue])  number:2];
	[currentDevice  setWireName:NXCopyStringBuffer([subWire4 stringValue])  number:3];
	[currentDevice  setWireName:NXCopyStringBuffer([subWire5 stringValue])  number:4];
	[currentDevice  setWireName:NXCopyStringBuffer([subWire6 stringValue])  number:5];
	[currentDevice  setWireName:NXCopyStringBuffer([subWire7 stringValue])  number:6];
	[currentDevice  setWireName:NXCopyStringBuffer([subWire8 stringValue])  number:7];
	[currentDevice  setWireName:NXCopyStringBuffer([subWire9 stringValue])  number:8];
	[NXApp stopModal];
	return self;
}

- Cancel:sender
{
    returnCondition = NO;
    [NXApp stopModal];
    return self;
}
	
- drawSelf:(NXRect*)r :(int)c
{
	int	i;
	NXPoint spot;

/* 	Erase the background, set the linewidth and default gray value */

	NXEraseRect (&bounds);
	PSsetgray (NX_BLACK);
	PSsetlinewidth (1.0);
	
/*	Build the path that defines the pie chart, nothing is drawn yet ...  */

//	PSnewpath ();
//	   PSmoveto (200.0, 80.0);
//	   PSarc (200.0, 80.0, 80.0, 0.0, 360.0);
//	PSclosepath ();
	
/*	Save the graphics state and fill the inside of the path in 50 % gray */

//	PSgsave ();
//	   PSsetgray (0.5);
//	   PSfill ();
//	PSgrestore ();
	
/* 	Draw the outline of the path in black  */

//	PSstroke ();
	
	spot.x = DEVICEOFFSETH; spot.y = DEVICEOFFSETV;
 	[[currentDevice deviceBitmap] composite:NX_SOVER toPoint:&spot];

	for(i=0;i<9;i++)
	{
		if(tempWirePointH[i] == -999) {
			KDrawGrayDot(7.0,(2*(8-i)+1)*bounds.size.height/18);
		} else {
			KDrawBlackDot(7.0,(2*(8-i)+1)*bounds.size.height/18);
			PSnewpath ();
			  PSmoveto(7.0,(2*(8-i)+1)*bounds.size.height/18);
			  PSlineto(DEVICEOFFSETH+tempWirePointH[i],DEVICEOFFSETV+tempWirePointV[i]);
			PSclosepath ();
			PSstroke ();
			KDrawBlackDot(DEVICEOFFSETH+tempWirePointH[i],DEVICEOFFSETV+tempWirePointV[i]);
		}
	}
    return self;
}

- mouseDown:(NXEvent *)event
{
   	NXPoint p, start;
    	int	i;

    start = event->location;
    [self convertPoint:&start fromView:nil];
	for(i = 0; i<9; ++i)
		if(KIsNear(7.0,(2*(8-i)+1)*bounds.size.height/18,start.x,start.y) ||
			KIsNear(DEVICEOFFSETH+tempWirePointH[i],DEVICEOFFSETV+tempWirePointV[i],start.x,start.y))
				break;
	if(i == 9) {
		NXBeep(); 
		return self;
	}

	[window addToEventMask:NX_MOUSEDRAGGEDMASK|NX_MOUSEUPMASK];

	event = [NXApp getNextEvent:NX_MOUSEDRAGGEDMASK|NX_MOUSEUPMASK];
	while (event->type != NX_MOUSEUP) {
		p = event->location;
		[self convertPoint:&p fromView:nil];
		if(p.x!=tempWirePointH[i] || p.y!=tempWirePointV[i]) {
			tempWirePointH[i] = p.x-DEVICEOFFSETH;	
			tempWirePointV[i] = p.y-DEVICEOFFSETV;	
			[self display];
		}
		event = [NXApp getNextEvent:NX_MOUSEDRAGGEDMASK|NX_MOUSEUPMASK];
	}
	if(![self mouse:&p inRect:&bounds] || p.x<30.0) {
		tempWirePointH[i] = -999.;
		NXBeep(); 
	} else {	
		tempWirePointH[i] = p.x-DEVICEOFFSETH;	
		tempWirePointV[i] = p.y-DEVICEOFFSETV;
	}
	[self display];
	return self;
}

- (BOOL)editDeviceModal:device
{
	int	i;
	currentDevice = device;
	[[descriptionScrollView docView] setText:[device title]];
	[[codeScrollView docView] setText:[device code]];
	[subWire1 setStringValue:[device wireName:0]];
	[subWire2 setStringValue:[device wireName:1]];
	[subWire3 setStringValue:[device wireName:2]];
	[subWire4 setStringValue:[device wireName:3]];
	[subWire5 setStringValue:[device wireName:4]];
	[subWire6 setStringValue:[device wireName:5]];
	[subWire7 setStringValue:[device wireName:6]];
	[subWire8 setStringValue:[device wireName:7]];
	[subWire9 setStringValue:[device wireName:8]];
	for(i=0;i<9;i++) {
		tempWirePointH[i] = [device wirePointH:i];
		tempWirePointV[i] = [device wirePointV:i];
	}
	[self display];
	[NXApp runModalFor:window];
	[window orderOut:self];
	return	returnCondition;  /* returns cancel or OK  */
}


@end
