#import "Wire.h"
#import "GraphicView.h"
#import "draw.h"
#import <appkit/Application.h>
#import <appkit/Cursor.h>
#import <appkit/Window.h>
#import <appkit/defaults.h>
#import <appkit/timer.h>
#import <appkit/nextstd.h>
#import <dpsclient/wraps.h>
#import <math.h>
#include <stdio.h>

extern BOOL KIsNear(float h1,float v1,float h2,float v2);

@implementation Wire

+ cursor
{
    NXPoint spot;
    static id cursor = nil;

    if (!cursor) {
	cursor = [Cursor newFromMachO:"Wire.tiff"];
	spot.x = 0.0; spot.y = 15.0;
	[cursor setHotSpot:&spot];
    }

    return cursor ? cursor : [super cursor];
}

#define stopTimer(timer) if (timer) { \
    NXEndTimer(timer); \
    timer = NULL; \
}

#define startTimer(timer) if (!timer) timer = NXBeginTimer(NULL, 0.1, 0.1);

#define RESIZE_MASK (NX_MOUSEUPMASK|NX_MOUSEDRAGGEDMASK|NX_TIMERMASK)

- resize:(NXEvent *)event by:(int)corner in:view
/*
 * Resizes the graphic by the specified corner.  If corner == CREATE,
 * then it is resized by the UPPER_RIGHT corner, but the initial size
 * is reset to 1 by 1.
 */
{
    NXPoint p, last;
    float aspect = 0.0;
    id window = [view window];
    BOOL constrain, canScroll;
    DrawStatusType oldDrawStatus;
    NXTrackingTimer *timer = NULL;
    NXRect eb, oldeb, visibleRect;

    if (!gFlags.active || !gFlags.selected || !corner) return self;

    constrain = ((event->flags & NX_ALTERNATEMASK) &&
	bounds.size.width && bounds.size.height);
    if (constrain) aspect = bounds.size.width / bounds.size.height;
    if (corner == CREATE) {
	bounds.size.width = bounds.size.height = 1.0;
	corner = UPPER_RIGHT;
    }

    gFlags.selected = NO;

    [self getExtendedBounds:&eb];
    [view lockFocus];
    gFlags.active = NO;
    [view cache:&eb];
    gFlags.active = YES;
    [self draw:NULL];
    [window flushWindow];

    oldDrawStatus = DrawStatus;
    DrawStatus = Resizing;

    [view getVisibleRect:&visibleRect];
    canScroll = !NXEqualRect(&visibleRect, &bounds);
    if (canScroll) startTimer(timer);

    while (event->type != NX_MOUSEUP) {
	p = event->location;
	event = [NXApp getNextEvent:RESIZE_MASK];
	if (event->type == NX_TIMER) event->location = p;
	p = event->location;
	[view convertPoint:&p fromView:nil];
	if( ![view solder:&p] )   /*KHL*/
    		[view grid:&p];  /*KHL*/
	if (p.x != last.x || p.y != last.y) {
	    corner = [self moveCorner:corner to:&p constrain:constrain];
	    if (constrain) [self constrainCorner:corner toAspectRatio:aspect];
	    oldeb = eb;
	    [self getExtendedBounds:&eb];
	    [window disableFlushWindow];
	    [view drawSelf:&oldeb :1];
	    if (canScroll) {
		[view scrollRectToVisible:&bounds];
		[view scrollPointToVisible:&p];
	    }
	    [self draw:NULL];
	    [window reenableFlushWindow];
	    [window flushWindow];
	    last = p;
	    NXPing();
	}
    }

    if (canScroll) stopTimer(timer);

    gFlags.selected = YES;
    DrawStatus = oldDrawStatus;

    [view cache:&eb];
    [window flushWindow];
    [view unlockFocus];

    return self;
}

- (BOOL)create:(NXEvent *)event in:view
/*
 * This method rarely needs to be subclassed.
 * It sets up an initial bounds, and calls resize:by:in:.
 */
{
    BOOL valid;
    NXCoord gridSpacing;
    NXPoint pt;

    bounds.origin.x = -99999.;
    pt = event->location;
    [view convertPoint:&pt fromView:nil];
    if( ![view solder:&pt] )   /*KHL*/
    	[view grid:&pt];  /*KHL*/
    bounds.origin = pt;

    gridSpacing = (NXCoord)[view gridSpacing];
    bounds.size.height = gridSpacing;
    bounds.size.width = gridSpacing * [self naturalAspectRatio];

    [self resize:event by:CREATE in:view];

    valid = [self isValid];

    if (valid) {
	gFlags.selected = YES;
	gFlags.active = YES;
    } else {
	gFlags.selected = NO;
	gFlags.active = NO;
	[view display];
    }

    return valid;
}

- (BOOL)solderTo:(NXPoint *)p     /*KHL*/
{
	if(gFlags.downhill) {
		if(KIsNear(p->x,p->y,bounds.origin.x,bounds.origin.y+bounds.size.height)) {
			p->x =bounds.origin.x;
			p->y =bounds.origin.y+bounds.size.height;
			return	YES;
		}
		if(KIsNear(p->x,p->y,bounds.origin.x+bounds.size.width,bounds.origin.y)) {
			p->x =bounds.origin.x+bounds.size.width;
			p->y =bounds.origin.y;
			return	YES;
		}
	} else {
		if(KIsNear(p->x,p->y,bounds.origin.x,bounds.origin.y)) {
			p->x =bounds.origin.x;
			p->y =bounds.origin.y;
			return	YES;
		}
		if(KIsNear(p->x,p->y,bounds.origin.x+bounds.size.width,bounds.origin.y+bounds.size.height)) {
			p->x =bounds.origin.x+bounds.size.width;
			p->y =bounds.origin.y+bounds.size.height;
			return	YES;
		}
	}

	return	NO;
}

- setGroup:(int) i
{
    group = i;
    return self;
}

- (int) group;
{
    return group;
}

- points:(NXPoint *) pt1 to:(NXPoint *) pt2
{
	if(gFlags.downhill) {
			pt1->x =bounds.origin.x;
			pt1->y =bounds.origin.y+bounds.size.height;
			pt2->x =bounds.origin.x+bounds.size.width;
			pt2->y =bounds.origin.y;
	} else {
			pt1->x =bounds.origin.x;
			pt1->y =bounds.origin.y;
			pt2->x =bounds.origin.x+bounds.size.width;
			pt2->y =bounds.origin.y+bounds.size.height;
	}
    return self;
}

char		theWireName[10];
- (char *) theWireOrTextName
{
	sprintf(theWireName,"Wire%d\0",group);
	return(theWireName);
}
	

@end

