#import <objc/Object.h>
#import <appkit/graphics.h>

#define KNOB_DY_ONCE  0x1
#define KNOB_DY_TWICE 0x2
#define KNOB_DX_ONCE  0x4
#define KNOB_DX_TWICE 0x8

/* corners */

#define LOWER_LEFT	(0x10)
#define LEFT_SIDE	(KNOB_DY_ONCE)
#define UPPER_LEFT	(LEFT_SIDE|KNOB_DY_TWICE)
#define TOP_SIDE	(UPPER_LEFT|KNOB_DX_ONCE)
#define UPPER_RIGHT	(TOP_SIDE|KNOB_DX_TWICE)
#define BOTTOM_SIDE	(KNOB_DX_ONCE)
#define LOWER_RIGHT	(BOTTOM_SIDE|KNOB_DX_TWICE)
#define RIGHT_SIDE	(LOWER_RIGHT|KNOB_DY_ONCE)

/* special corner which means upper right, but also note that we're creating */

#define CREATE		(0x20)

/* corner mask values */

#define LOWER_LEFT_MASK		(1 << LOWER_LEFT)
#define LEFT_SIDE_MASK		(1 << LEFT_SIDE)
#define UPPER_LEFT_MASK		(1 << UPPER_LEFT)
#define TOP_SIDE_MASK		(1 << TOP_SIDE)
#define UPPER_RIGHT_MASK	(1 << UPPER_RIGHT)
#define BOTTOM_SIDE_MASK	(1 << BOTTOM_SIDE)
#define LOWER_RIGHT_MASK	(1 << LOWER_RIGHT)
#define RIGHT_SIDE_MASK		(1 << RIGHT_SIDE)
#define ALL_CORNERS		0xffffffff

#define ARROW_AT_START	1
#define ARROW_AT_END	2
#define ARROW_AT_BOTH	3

extern id CrossCursor;

@interface Graphic : Object
{
    NXRect bounds;			/* the bounds */
    float linewidth;			/* linewidth */
    float gray;				/* gray */
    struct _gFlags {
	unsigned int selected:1;	/* whether selected */
	unsigned int active:1;		/* whether to really draw in draw: */
	unsigned int eofill:1;		/* whether eofilled */
	unsigned int isFramed:1;	/* whether to put frame around fill */
	unsigned int downhill:1;	/* Line: direction line goes */
	unsigned int initialized:1;	/* subclass specific */
	unsigned int linewidthSet:1;	/* used when archiving */
	unsigned int graySet:1;		/* used when archiving */
	unsigned int linejoin:2;	/* line join */
	unsigned int linecap:2;		/* line cap */
	unsigned int fill:1;		/* whether filled */
	unsigned int locked:1;		/* locked down? */
	unsigned int arrow:2;		/* arrow position */
    } gFlags;
}

/* Factory methods */

+ (BOOL)isEditable;
+ cursor;
+ new;

/* Called when a GraphicView is unarchived */

- awake;

/* Private methods (for subclassers only) */

- setGraphicsState;
- (int)cornerMask;

/* Public routines (called mostly by a GraphicView or subclassers). */

- (BOOL)isSelected;
- (BOOL)isActive;
- (BOOL)isLocked;
- select;
- deselect;
- activate;
- deactivate;
- lock;
- unlock;

- getBounds:(NXRect *)theRect;
- setBounds:(const NXRect *)aRect;
- (NXRect *)getExtendedBounds:(NXRect *)theRect;

- (int)knobHit:(const NXPoint *)point;

- draw:(const NXRect *)rect;

- moveBy:(const NXPoint *)offset;
- moveTo:(const NXPoint *)p;
- centerAt:(const NXPoint *)center;
- sizeTo:(const NXSize *)size;
- sizeToNaturalAspectRatio;
- alignToGrid:graphicView;
- sizeToGrid:graphicView;

/* Public routines (called mostly by inspectors and the like). */

- setLineWidth:(const float *)value;
- (float)lineWidth;
- setGray:(const float *)value;
- (float)gray;
- setFill:(int)mode;
- (int)fill;
- (BOOL)isFilled;
- setFramed:(BOOL)yesOrNo;
- (BOOL)isFramed;
- setLineCap:(int)capValue;
- (int)lineCap;
- setLineArrow:(int)arrowValue;
- (int)lineArrow;
- setLineJoin:(int)joinValue;
- (int)lineJoin;

/* Archiving (must be overridden by subclasses with instance variables) */

- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

/* Routines intended to be subclassed for different types of Graphics. */

/*
 * Can be overridden to provide more sophisticated size constraining
 * than an aspect ratio (though that is almost always sufficient).
 * For example, Line overrides this to constrain to closes 15 degree angle.
 */

- constrainCorner:(int)corner toAspectRatio:(float)aspect;

/*
 * Can be overridden to resize the Graphic differently than the
 * default (which is to drag out the bounds), or to do something
 * before and/or after the subclass is resized.  This is called
 * during the default creation method as well (create:in:).
 */

- resize:(NXEvent *)event by:(int)corner in:view;

/*
 * Possible override candidate for different types of Graphics.
 * Should return YES if the Graphic got created okay.
 * The most common need to override this method is if the creation
 * of the Graphic requires multiple mouseUps and mouseDowns (for
 * an arbitrary arc, for example).
 */

- (BOOL)create:(NXEvent *)event in:view;

/*
 * Override hit: if you want your subclass to only get selected when the
 * mouse goes down in certain parts of the bounds (not the whole bounds).
 * e.g. Lines only get selected if you click close to them.
 */

- (BOOL)hit:(const NXPoint *)point;

/*
 * Returns YES if this Graphic can't be seen through.
 * Default behaviour is to return YES if the Graphic isFilled.
 */

- (BOOL)isOpaque;

/*
 * Returns YES if the Graphic is properly formed (usually this just
 * refers to whether it is big enough to be a real graphic during creation).
 * This is called by create:in:.  By default it returns YES if the Graphic
 * is at least 10.0 by 10.0 pixels in size.
 */

- (BOOL)isValid;

/*
 * This is the Graphic's natural aspect ratio.  If it doesn't have a natural
 * aspect ratio, then this method should return zero (the default return).
 */

- (float)naturalAspectRatio;

/*
 * Called repeatedly as the user drags the mouse to create or resize
 * the Graphic.  The default implementation does the right thing.
 * The specified corner should be moved to the specified point.
 */

- (int)moveCorner:(int)corner to:(const NXPoint *)point constrain:(BOOL)flag;

/*
 * This routine actually draws the graphic.  It should be draw to fit the
 * bounds instance variable.  Be sure to use all the parameters listed in
 * the instance variable list (e.g. linewidth, fillgray, etc.) that are
 * appropriate to this object.  It is probably a good idea to do a newpath
 * and a closepath at the beginning and the end of draw.
 * If a sublcass just wants to draw a unit-sized version of itself
 * (i.e. it draws itself in a bounding box of {{0.0,0.0},{1.0,1.0}})
 * it can just override unitDraw (and not draw).
 */

- unitDraw;
- draw;

/*
 * Should return YES iff the Graphic can be "edited."  It is up to the
 * subclass of Graphic to determine what this means for it.  Usually
 * it means that it has text and allows that text to be edited by the
 * user (e.g. TextGraphic).  Default is to do nothing and return NO.
 */

- (BOOL)edit:(NXEvent *)event in:view;

- (BOOL)solderTo:(NXPoint *)p; /*KHL used to move p to nearest solder point within dotsize dist.*/

@end

