#import <appkit/Application.h>

@interface DrawApp : Application
{
    id cSoundTools;			/* the CSound Tool Palette matrix */
    id tools;			/* the Tool Palette matrix */
    id currentGraphic;		/* the factory object used to create things */
    id savePanelAccessory;	/* the SavePanel Draw/PS/TIFF view */
    id spamatrix;		/* the matrix in the savePanelAccessory view */
    id infoPanel;		/* the Info... panel */
    id version;			/* the version field in the Info... panel */
    id gridInspector;		/* the shared modal panel to inspect grids */
    id inspectorPanel;		/* the shared inspector panel */
    id activateMenu;		/* activate menu */
    BOOL cursorPushed;		/* whether we've temporarily changed the
				   cursor to NXArrow because the user held
				   down the Control key */
    id	myDeviceInspectorView; /* KHL */
    id compileInfoPanel;
    id compileInfo;
}

/* Public methods */

+ initialize;
+ new;

- currentGraphic;
- currentDocument;

/* Shared panels */

- saveToPanel;
- saveAsPanel;
- gridInspector;
- inspectorPanel;
- orderFrontInspectorPanel:sender;
- myDeviceInspectorView;	/* KHL */
- compileInfo;

/* Target/Action methods */

- help:sender;
- info:sender;
- new:sender;
- open:sender;
- terminate:sender;

/* Application delegate methods */

- appDidInit:sender;
- (int)appOpenFile:(const char *)path type:(const char *)type;
- (BOOL)appAcceptsAnotherFile:sender;

/* Listener/Speaker methods */

- (int)msgDirectory:(char * const *)fullPath ok:(int *)flag;
- (int)msgVersion:(char * const *)aString ok:(int *)flag;
- (int)msgFile:(char * const *)fullPath ok:(int *)flag;
- (int)msgPrint:(const char *)fullPath ok:(int *)flag;
- (int)msgSelection:(char * const *)bytes length:(int *)len
    asType:(const char *)aType ok:(int *)flag;
- (int)msgCopyAsType:(const char *)aType ok:(int *)flag;
- (int)msgCutAsType:(const char *)aType ok:(int *)flag;
- (int)msgPaste:(int *)flag;

/* Global cursor setting methods */

- cursor;
- sendEvent:(NXEvent *)event;

/* Text editing methods */

- setBlackText:sender;
- setWhiteText:sender;
- setDarkGrayText:sender;
- setLightGrayText:sender;
- centerText:sender;
- leftJustifyText:sender;
- rightJustifyText:sender;

/* Activate menu updating */

- addDocument:(const char *)name;
- removeDocument:(const char *)name;
- renameDocument:(const char *)oldName to:(const char *)newName;
- activateDocument:sender;

/* Menu updating methods */

- (BOOL)menuItemUpdate:menuCell;
- (BOOL)validateCommand:menuCell;

/* Target/Action method which sets the currentGraphic instance variable */

- setCurrentGraphic:sender;
- setMyDeviceInspectorView:anObject; /*KHL*/

@end



