
/* Generated by Interface Builder */

#import "DSPApp.h"
#import <appkit/appkit.h>
#import <objc/List.h>
#import <stdio.h>
#include	<string.h>
#import <sound/sound.h>
#import <sound/sounddriver.h>
#import <stdlib.h>
#import <libc.h>	/* for sleep */
#import <appkit/defaults.h>		/* NXArgv */
#import "slideController.h"

@implementation DSPApp

id	slideControllerList = nil;

- setMyMainWindow:anObject
{
    myMainWindow = anObject;
    return self;
}

BOOL	isFileOpen = NO;
BOOL	isDSPInited = NO;

/* use dspInit to setup all of the port communication with the DSP if not already done */
- (BOOL) dspInit:sender
{
		
   if(!isDSPInited) {
		/*  INITIALIZE DMA STREAMING VARIABLES  */
	low_water = 48*1024;
	high_water = 64*1024;
	read_width = 2;
	read_buf_size = 512;
	
	/*  GET THE DEVICE PORT FOR THE SOUND/DSP DRIVER ON THE LOCAL MACHINE  */
	k_err = netname_look_up(name_server_port,"","sound",&dev_port);
	if (k_err != KERN_SUCCESS) {
	  mach_error("netname lookup failure ",k_err);
	  return(0);
	}
	
	/*  GET THE OWNER PORT  */
	k_err = port_allocate(task_self(),&owner_port);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot allocate owner port ",k_err);
	  return(0);
	}
	
	/*  BECOME OWNER OF DSP RESOURCES  */
	temp_port = owner_port;
	k_err = snddriver_set_dsp_owner_port(dev_port,owner_port,&temp_port);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot become owner of dsp resources ",k_err);
	  return(0);
	}
	
	/*  GET THE DSP COMMAND PORT  */
	k_err = snddriver_get_dsp_cmd_port(dev_port,owner_port,&cmd_port);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot acquire command port ",k_err);
	  return(0);
	}
	
	/*  ACQUIRE OWNERSHIP OF THE SOUND OUTPUT DEVICE  */
	k_err = snddriver_set_sndout_owner_port(dev_port,owner_port,&temp_port);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot become owner of sound out device ",k_err);
	  return(0);
	}
	
	/*  SET UP TO STREAM DATA FROM THE DSP TO THE SOUND DEVICE  */
	protocol = 0;
	k_err = snddriver_stream_setup(dev_port,owner_port,SNDDRIVER_STREAM_DSP_TO_SNDOUT_44,
				       read_buf_size,read_width,low_water,high_water,
				       &protocol,&read_port);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot set up stream from DSP ",k_err);
	  return(0);
	}
	
	/*  SET THE DSP PROTOCOL  */
	k_err = snddriver_dsp_protocol(dev_port,owner_port,protocol);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot set up DSP protocol ",k_err);
	  return(0);
	}
	
	/*  ALLOCATE A PORT FOR REPLIES  */
	k_err = port_allocate(task_self(),&reply_port);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot allocate reply port ",k_err);
	  return(0);
	}
   }
   isDSPInited = YES;
   return (1);
}


- (BOOL) openAndLoadFile:(const char *)name
{
	FILE		*stream;
	int 		ch,i,j;
	NXRect	rect;
	char		comment[ ] = "_COMMENT";
	fpos_t	position;
	char		commentType[100];
	
	[myMainWindow  setTitle:name];

	if(slideControllerList==nil)  slideControllerList  = [List new];
	
	if(isFileOpen)	{
				// close any open things here
		[slideControllerList  freeObjects];
	}

/*  PARSE THE .LOD ASSEMBLY FILE AND BOOT THE DSP WITH IT  */
	s_err = SNDReadDSPfile(name,&dspStruct,NULL);
	if (s_err != SND_ERR_NONE) {
		NXRunAlertPanel("Cannot parse DSP code file:", SNDSoundError(s_err),
							 "OK", NULL, NULL) ;
		return NO;
	}

	s_err = SNDBootDSP(dev_port,owner_port,dspStruct);
	if (s_err != SND_ERR_NONE) {
		NXRunAlertPanel("Cannot boot DSP:", SNDSoundError(s_err),
							 "OK", NULL, NULL) ;
		return NO;
	}

	/*  START STREAM FROM THE DSP  */
	k_err = snddriver_stream_start_reading(read_port,NULL,
					       read_count,0,
					       0,0,0,0,0,0,reply_port);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot enqueue read request ",k_err);
	  return(0);
	}

	stream = fopen(name,"r");
	j = 0;
	while((ch = getc(stream)) != EOF)  {
		if(ch == comment[j])    j++;			// check for comment line
		else	if(ch=='_')    j=1;
		else	j=0;
		if(j == 8)  {
			j = 0;
			fscanf(stream,"%s",commentType);
			if(strcmp("slider",commentType) == 0) {             // I found a slider comment
				[self loadNibSection:"slideController.nib" owner:self withNames:NO];
				i = [slideControllerList  count] - 1;	// the last window  in list is the panel just loaded
				[[slideControllerList objectAt:i] getFrame:&rect];
				[[slideControllerList objectAt:i] moveTo:rect.origin.x :rect.origin.y-(60*i)];
				fgetpos(stream,&position);
				[[[slideControllerList objectAt:i] delegate] setup:stream]; 
								//the panels delegate is my slide control object
				fsetpos(stream,&position);
			}
		}
	}
	fclose(stream);

	isFileOpen = YES;
	return YES;
}

- sendToDSPNewWireValue:(int *)ptrReply
{
	k_err = snddriver_dsp_write(cmd_port,ptrReply,2,4,SNDDRIVER_MED_PRIORITY);
	if (k_err != KERN_SUCCESS) {
	  mach_error("Cannot write to DSP ",k_err);
 	 return(0);
	}
	return self;
}

- appDidInit:sender
{
	[self dspInit:self];
	if (NXArgc > 1)   [self  openAndLoadFile:NXArgv[1]] ;
	return self;
}


- (int)appOpenFile:(const char *)path type:(const char *)type
/*
 * This method is performed whenever a user double-clicks on an icon
 * in the Workspace Manager .
 */
{
	[self dspInit:self];
	return [self  openAndLoadFile:path] ;
}

- (BOOL)appAcceptsAnotherFile:sender
{
	return	YES;		/* always can open another file */
//	return !isFileOpen;
}

- terminate:sender
{
	return [super terminate:sender];
}

- setSlideController:anObject
{
	[slideControllerList  addObject:anObject];
	return self;
}


@end
