MIDI3   MACRO   PIT3,VEL3,SPLIT1,PIT2,VEL2,SPLIT2,PIT1,VEL1,PWHEEL,MWHEEL,PROGNUM  ;THE MIDI HANDLER
; Written by Keith Lent, University of Texas, 1988
        ORG     X:
; STORE JUMP LOCATIONS FOR EACH 4-BIT MIDI STATUS VALUE
_DUMMY  SET     @LCV(L)   ;REMEMBER OLD LOCATION
        ORG X:$0
        DC      _M_STAT   ;0
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT
        DC      _M_STAT   ;8
        DC      _NOTE_ON        ;9
        DC      _M_STAT   ;A
        DC      _M_WHEEL        ;B
        DC      _P_NUMB   ;C
        DC      _M_STAT   ;D
        DC      _P_WHEEL        ;E
        DC      _M_STAT   ;F
        ORG     X:_DUMMY        ;REPLACE POINTER
        ORG     Y:
_TEMP   DC      0   ;TEMP STORAGE FOR MSB/LSB HOLDER
        ORG     P:
         ;CHECK FOR MIDI DATA
_JMPLOC JSET    #2,X:$FFF1,>_M_STAT
        JMP     _END
_M_STAT
        MOVEP   X:$FFF4,X0
        CLR     B   #$08,X1    ;SHIFT 4-BITS CONSTANT
        MPY     X1,X0,A   #$F8,B1
        CMP     X0,B   A1,R0  ;AVOID REAL TIME MESSAGE
        JLE     _END
        MOVE    X:(R0),X0
        MOVEM   X0,P:(_JMPLOC+1)
        JMP     _END
_NOTE_ON
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
;
        MOVEP   X:$FFF6,B       ;GET PITCH BYTE
        MOVE    #SPLIT1,A
        CMP             A,B             #SPLIT2,A
        JLE             _NOTE3
        CMP             A,B
        JLE             _NOTE2
_NOTE1
        MOVE    B,Y:(_TEMP)     ;GET PITCH BYTE (HIGH BITS)
        MOVE    #_VEL_ON1,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_NOTE2
        MOVE    B,Y:(_TEMP)     ;GET PITCH BYTE (HIGH BITS)
        MOVE    #_VEL_ON2,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_NOTE3
        MOVE    B,Y:(_TEMP)     ;GET PITCH BYTE (HIGH BITS)
        MOVE    #_VEL_ON3,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_VEL_ON1
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVE    Y:(PIT1),B
        MOVE    Y:(_TEMP),Y0
        CMP     Y0,B    X:$FFF6,A       ;GET VELOCITY BYTE (HIGH BITS)
        JNE     _DIFF1 ;DIFFERENT THAN LAST PITCH
        MOVE    A,Y:(VEL1)
        JMP     _VEND1
_DIFF1
        TST     A ;NOTE ON OR OFF
        JEQ     _VEND1 ;NO CHANGE IF NOTE OFF
        MOVE    Y0,Y:(PIT1)   ;NEW ON NOTE
        MOVE    A,Y:(VEL1)    ;AND VELOCITY
_VEND1
        MOVE    #_NOTE_ON,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_VEL_ON2
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVE    Y:(PIT2),B
        MOVE    Y:(_TEMP),Y0
        CMP     Y0,B    X:$FFF6,A       ;GET VELOCITY BYTE (HIGH BITS)
        JNE     _DIFF2 ;DIFFERENT THAN LAST PITCH
        MOVE    A,Y:(VEL2)
        JMP     _VEND2
_DIFF2
        TST     A ;NOTE ON OR OFF
        JEQ     _VEND2 ;NO CHANGE IF NOTE OFF
        MOVE    Y0,Y:(PIT2)   ;NEW ON NOTE
        MOVE    A,Y:(VEL2)    ;AND VELOCITY
_VEND2
        MOVE    #_NOTE_ON,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_VEL_ON3
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVE    Y:(PIT3),B
        MOVE    Y:(_TEMP),Y0
        CMP     Y0,B    X:$FFF6,A       ;GET VELOCITY BYTE (HIGH BITS)
        JNE     _DIFF3 ;DIFFERENT THAN LAST PITCH
        MOVE    A,Y:(VEL3)
        JMP     _VEND3
_DIFF3
        TST     A ;NOTE ON OR OFF
        JEQ     _VEND3 ;NO CHANGE IF NOTE OFF
        MOVE    Y0,Y:(PIT3)   ;NEW ON NOTE
        MOVE    A,Y:(VEL3)    ;AND VELOCITY
_VEND3
        MOVE    #_NOTE_ON,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_P_WHEEL
        JSET    #7,X:$FFF4,_M_STAT      ;NO MORE DATA
;
        MOVEP   X:$FFF5,A   ;GET LSB P.WHEEL BYTE
        LSL     A       #$C0,X0
        ADD     X0,A
        MOVE    A,Y:(_TEMP)
        MOVE    #_PW_MSB,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_PW_MSB
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVE    Y:(_TEMP),A
        MOVE    X:$FFF6,X0
        ADD     X0,A
        MOVE    A,Y:(PWHEEL)
        MOVE    #_P_WHEEL,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_M_WHEEL
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
;
        MOVEP   X:$FFF6,A   ;GET CONTROL #
        MOVE    #$01,X0
        CMP     X0,A
        JEQ     _MWH2 ;IF MSB OF MOD. WHEEL
        MOVE    #_M_STAT,A0   ;OTHERWISE SKIP IT
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_MWH2
        MOVE    #_MW_MSB,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_MW_MSB
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVEP   X:$FFF6,Y:(MWHEEL)      ;GET VALUE (HIGH BITS)
        MOVE    #_M_WHEEL,A0   ;GET NEXT POINTER
        MOVEM   A0,P:(_JMPLOC+1)
        JMP     _END
_P_NUMB
        JSET    #7,X:$FFF4,_M_STAT      ;NOT DATA
        MOVEP   X:$FFF6,A   ;GET NEW PROGRAM NUMBER
        MOVE    A,Y:(PROGNUM)
        JMP     _END

_END
        ENDM
