COMB    MACRO  OUT,IN,RATE,nnn,iscl
; Written by Keith Lent, University of Texas, 1988
;   A nnn SAMPLE DELAY COMB FILTER
;   RATE - THE DECAY RATE COEFICIENT i.e. y(n)= A*x(n) + RATE*y(n-nnn)
;       where iscl=1   ==>   A=1
; and   iscl=2   ==>   A=(1-RATE)
        ORG     YH:
_BUFF   DSM     nnn
        ORG     X:
_PTR    DC      _BUFF
        ORG     P:
        MOVE    X:(_PTR),R4
        MOVE    #(nnn-1),M4
        MOVE    Y:(IN),A
        IF      (iscl==1)
                MOVE    Y:(R4),B
                SUB     A,B     Y:(RATE),Y1
                MOVE    B,X1
        ELSE
                MOVE    Y:(R4),X1
                MOVE    Y:(RATE),Y1
        ENDIF
        MACR    X1,Y1,A
        MOVE    A,Y:(R4)+
        MOVE    R4,X:(_PTR)
        MOVE    A,Y:(OUT)
        ENDM
