#import "Graphic.h"

@interface Group : Graphic
{
    id components;	/* the Graphics in the group */
    NXRect lastRect;	/* the last rectangle the group was drawn in */
}

/* Factory method */

+ newList:list;

/* Public methods */

- free;
- list;

/* Methods overridden from superclass */

- draw;
- (BOOL)hit:(const NXPoint *)point;

/* Group must override all the setting routines to forward to components */

- setLineWidth:(const float *)value;
- setGray:(const float *)value;
- setFill:(int)mode;
- setFramed:(BOOL)flag;
- setLineCap:(int)capValue;
- setLineArrow:(int)arrowValue;
- setLineJoin:(int)joinValue;

/* Archiving methods */

- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

@end

