#import <appkit/View.h>

typedef enum { Normal, Resizing } DrawStatusType;

extern DrawStatusType DrawStatus;
extern const char DrawPBType[];
extern BOOL InMsgPrint;

@interface GraphicView : View
{
    id glist;				/* the list of Graphics */
    id slist;				/* the list of selected Graphics */
    id cacheWindow;			/* the off-screen cache */
    struct {
	unsigned int groupInSlist:1;	/* whether a Group is in the slist */
	unsigned int cacheing:1;	/* whether cacheing or drawing */
	unsigned int dirty:1;		/* whether edited since last save */
	unsigned int grid:8;		/* grid size */
	unsigned int showGrid:1;	/* whether grid is visible */
	unsigned int locked:1;		/* some graphics are locked */
	unsigned int gridDisabled:1;	/* whether grid is enabled */
	unsigned int solderDisabled:1;	/* whether solder is enabled */ /*KHL*/
	unsigned int PADDING:1;		/* must pad to 16 bits */
    } gvFlags;
    short *gupCoords;			/* points in the grid user path */
    int gupLength;			/* number of points in gupCoords */
    char *gupOps;			/* movetos and linetos in the gup */
    short *gupBBox;			/* bounding box of the gup */
    float gridGray;			/* grayness of the grid */
    int consecutivePastes;		/* number of consecutive pastes */
    int lastPastedChangeCount;		/* the change count of last paste */
    id editView;			/* flipped subview for editing */
    id originalPaste;			/* the first pasted graphic */
}

/* Class initialization */

+ initialize;

/* Pasteboard lazy evaluation methods */

+ convertPasteboard:(NXTypedStream *)ts
    to:(const char *)type
    using:(SEL)writer;
+ provideData:(const char *)type;

/* Factory method */

+ newFrame:(const NXRect *)frameRect;

/* Free method */

- free;

/* Private methods */

- selectionCache;
- getBBox:(NXRect *)bbox of:list;
- recacheSelection;
- getSelection;
- compositeSelection:(const NXRect *)sbounds from:(int)gstate;
- (int)cacheSelection;

- cacheGraphic:graphic;
- resetGUP;
- (BOOL)move:(NXEvent *)event;
- dragSelect:(NXEvent *)event;

/* Public methods */

- currentGraphic;

- dirty;
- (BOOL)isDirty;
- (BOOL)isEmpty;
- (BOOL)hasEmptySelection;

- graphicsPerform:(SEL)aSelector andDraw:(BOOL)flag;
- graphicsPerform:(SEL)aSelector with:(void *)argument andDraw:(BOOL)flag;

- cache:(const NXRect *)rect;

- removeGraphic:graphic;
- insertGraphic:graphic;
- selectedGraphic;

- (int)gridSpacing;
- (BOOL)gridIsVisible;
- (BOOL)gridIsEnabled;
- (float)gridGray;
- setGridSpacing:(int)gridSpacing;
- setGridEnabled:(BOOL)flag;
- setGridVisible:(BOOL)flag;
- setGridGray:(float)gray;
- setGridSpacing:(int)gridSpacing
    andGray:(float)gray;
- grid:(NXPoint *)point;
- (BOOL) solder:(NXPoint *)point;

- placeGraphic:graphic at:(const NXPoint *)location;
- loadPostScriptFromStream:(NXStream *)stream at:(const NXPoint *)location;
- loadTIFFFromStream:(NXStream *)stream at:(const NXPoint *)location;

/* Writing alternate types of data */

- writePSToStream:(NXStream *)stream;
- writeTIFFToStream:(NXStream *)stream;

/* Methods overridden from superclass */

- sizeTo:(NXCoord)width :(NXCoord)height;
- mouseDown:(NXEvent *)event;
- drawSelf:(const NXRect *)rects :(int)rectCount;
- keyDown:(NXEvent *)event;

/* Copying the selection to a stream */

- copySelectionAsPS:(NXStream *)stream;
- copySelectionAsTIFF:(NXStream *)stream;
- copySelectionToStream:(NXStream *)stream;

/* Target/Action methods */

- setCurrentGraphic:sender;
- cut:sender;
- copy:sender;
- paste:sender;
- selectAll:sender;
- deselectAll:sender;
- lock:sender;
- unlock:sender;
- bringToFront:sender;
- sendToBack:sender;
- group:sender;
- ungroup:sender;
- changeAspectRatio:sender;
- alignToGrid:sender;
- sizeToGrid:sender;
- enableGrid:sender;
- hideGrid:sender;
-newDeviceFromPasteboard:sender;
		/* --- the following routines compile the picture into source code ----------*/
- KGroup:(id) g groupNumber:(int) gNum;
- compile:sender;

/* Target/Action messages sent from Controls to set various parameters */

- takeGridValueFrom:sender;
- takeGridGrayFrom:sender;
- takeGrayValueFrom:sender;
- takeLineWidthFrom:sender;
- takeLineJoinFrom:sender;
- takeLineCapFrom:sender;
- takeLineArrowFrom:sender;
- takeFillValueFrom:sender;
- takeFrameValueFrom:sender;

/* Accepting becoming the First Responder */

- (BOOL)acceptsFirstResponder;

/* Printing-related methods */

- beginPrologueBBox:(NXRect *)boundingBox creationDate:(char *)dateCreated
    createdBy:(char *)anApplication fonts:(char *)fontNames
    forWhom:(char *)user pages:(int )numPages title:(char *)aTitle;
- beginSetup;

/* Archiving methods */

- awake;
- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

/* Validates whether a menu command makes sense now */

- (BOOL)validateCommand:menuCell;

/* Useful scrolling methods */

- scrollGraphicToVisible:graphic;
- scrollPointToVisible:(const NXPoint *)point;

@end

/*
 * Since we can't be sure that we have an InspectorPanel, we use the
 * objective-C respondsTo: mechanism to see if we can send the message
 * initializeGraphic: to [NXApp inspectorPanel].  This dummy interface
 * declaration declares those messages (so that even if they don't exists,
 * we can at least use them to check with respondsTo:).  We don't want
 * to import DrawApp.h or InspectorPanel.h since we might accidentally
 * introduce a dependency on them which wouldn't be caught because we
 * imported both of their interfaces.
 */

@interface PossibleInspectorPanel : Object

- inspectorPanel;
- initializeGraphic:graphic;

@end

