#import "Circle.h"
#import "draw.h"
#import <appkit/nextstd.h>
#import <math.h>

@implementation Circle : Graphic

- (int)cornerMask
/*
 * Put resize knobs only on the points where the oval touches the bounds.
 */
{
    return LEFT_SIDE_MASK|TOP_SIDE_MASK|RIGHT_SIDE_MASK|BOTTOM_SIDE_MASK;
}
	     
- (float)naturalAspectRatio
/*
 * The natural aspect ratio of an oval is 1.0 (a circle).
 */
{
    return 1.0;
}

- draw
{
    if (bounds.size.width < 1.0 || bounds.size.height < 1.0) return self;

    if (gFlags.eofill || gFlags.fill) {
	if (gFlags.isFramed) {
	    PSOval(bounds.origin.x, bounds.origin.y,
		   bounds.size.width, bounds.size.height);
	} else {
	    PSFilledOval(bounds.origin.x, bounds.origin.y,
			 bounds.size.width, bounds.size.height);
	}
    } else {
	PSFramedOval(bounds.origin.x, bounds.origin.y,
		     bounds.size.width, bounds.size.height);
    }

    return self;
}

- (BOOL)hit:(const NXPoint *)p
/*
 * Hit only if inside the interior of the oval.
 */
{
    NXCoord x, y;
    NXPoint center;
    double angle, radius, diameter;

    if ([super hit:p]) {
	center.x = bounds.origin.x + bounds.size.width / 2.0;
	center.y = bounds.origin.y + bounds.size.height / 2.0;
	diameter = MIN(bounds.size.width, bounds.size.height);
	x = fabs(center.x - p->x) / (bounds.size.width / diameter);
	y = fabs(center.y - p->y) / (bounds.size.height / diameter);
	angle = atan2(y, x);
	radius = diameter / 2.0;
	return(x < radius * cos(angle) && y < radius * sin(angle));
    } else {
	return NO;
    }
}


@end

