VRESON  MACRO  OUT,IN,COEFPTR,minp,maxp,minf,maxf,minbw,maxbw,eorl,iscl
; Written by Keith Lent, University of Texas, 1988
;*********************
;   2ND ORDER FILTER --  Y(n)= 2*{ X(n)*A + Y(n-1)*B + Y(n-2)*C }
;               WITH OUTPUT(n) = Y(n-1)
;   small letters mean compiltime constants
;   COEFPTR = pointer to look up table values $000000 to $7f0000
;               truncated to the most significant byte
;   minp = minimum coef pointer to be used  0 - 127
;   maxp = maximum coef pointer to be used  0 - 127
;   eorl = E or L for exponetial or linear interpolations between
;               minimums and maximums
;       create filter coefs table
;
        ORG     YH:
_F_COEF
        IF      (@SCP("eorl",'E'))
temp_f  set     @POW(maxf/minf,1./8.)
root_f  set     @POW(temp_f,8./@CVF(maxp-minp))
temp_b  set     @POW(maxbw/minbw,1./8.)
root_b  set     @POW(temp_b,8./@CVF(maxp-minp))
pi      set     3.141529
 
count   set     minp
        dup     maxp-minp+1
freq    set     minf*@POW(root_f,@CVF(count-minp))
bw      set     minbw*@POW(root_b,@CVF(count-minp))
ccc     set     @XPN(-2.*pi*bw/S_RATE)
bbb     set     -4.*ccc/(1.+ccc)*@COS(2.*pi*freq/S_RATE)
        IF      (iscl==2)
aaa     set     @SQT(((1+ccc)*(1+ccc)-bbb*bbb)*(1-ccc)/(1+ccc))
        ELSE
aaa     set     @SQT(1-bbb*bbb/(4.*ccc))*(1-ccc)
        ENDIF
        dc      aaa/2.
        dc      -bbb/2.
        dc      -ccc/2.
count   set     count+1
        endm
        ELSE
pi      set     3.141529
count   set     minp
        dup     maxp-minp+1
ratio   set     @CVF(count-minp)/@CVF(maxp-minp)
freq    set     minf+(maxf-minf)*ratio
bw      set     minbw+(maxbw-minbw)*ratio
ccc     set     @XPN(-2.*pi*bw/S_RATE)
bbb     set     -4.*ccc/(1.+ccc)*@COS(2.*pi*freq/S_RATE)
        IF      (iscl==2)
aaa     set     @SQT(((1+ccc)*(1+ccc)-bbb*bbb)*(1-ccc)/(1+ccc))
        ELSE
aaa     set     @SQT(1-bbb*bbb/(4.*ccc))*(1-ccc)
        ENDIF
        dc      aaa/2.
        dc      -bbb/2.
        dc      -ccc/2.
count   set     count+1
        endm
        ENDIF

        ORG     XL:
_VALS   DSM     2
        ORG     P:
        MOVE    Y:(COEFPTR),B
        ABS     B       #<$7F,Y0
        AND     Y0,B    #>$000180,Y0
        MOVE    #(_F_COEF-minp*3),A     B,y1
        MAC     Y0,y1,A         Y:(IN),X0
        MOVE    A,R0
        MOVE    #_VALS,R4
        MOVE    Y:(R0)+,Y0
        MPY     Y0,X0,A         Y:(R0)+,Y0      X:(R4)+,X0
        MAC     Y0,X0,A         Y:(R0),Y0       X:(R4),X1
        MACR    Y0,X1,A         X0,X:(R4)-
        ASL     A               X0,Y:(OUT)
        MOVE    A,X:(R4)
        ENDM
