NEXTOUT     MACRO   RCHAN,LCHAN 
; Written by Keith Lent, University of Texas, 1990
; This macro uses a lot of symbols that are created and defined in the NEXTHEADER macro.
        ORG     P:
	move	#DMASIZE-1,m4
	move	y:y_OutputPtr,r4				;**get old output pointer
	move	#1.0/256,x0
	move			y:RCHAN,x1
	mpy		x0,x1,a	y:LCHAN,x1
	mpy		x0,x1,a	a,x:(r4)+
	move	a,x:(r4)+
	move	r4,a				;now test to see if buffer is full
	move	#XDMABUF,b
	cmp		a,b		r4,y:y_OutputPtr		;**store new output pointer
	jne		_exit				;exit if not full

_transfer
	jclr	#m_htde,x:m_hsr,_transfer	; loop until htde bit HSR is set
	movep	#DMA_R_REQ,x:m_htx	; send DMA initiate read message to host

_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	; loop until host acknowledges (HF1=1)
								;r4 already points to beginning of DMA buffer
	do	#DMASIZE,_send_loop			; top of DMA buffer send loop
_send	jclr	#m_htde,x:m_hsr,_send	; loop until htde bit of HSR is set
	movep	x:(r4)+,x:m_htx		; send buffer element to host
_send_loop
	btst	#DMA_DONE,x:x_DMA_flags	; if interrupt has set flags, then go to end
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_send_loop	; else keep sending zeroes until interrupt sets flags
	movep	#0,x:m_htx
	jmp	_send_loop
_endDMA
	bclr	#DMA_DONE,x:x_DMA_flags	; reset flag to 0, we know we are done--be ready to
									; set flag on next interrupt
_ackEnd
	jset	#m_hf1,x:m_hsr,_ackEnd	; loop until host acknowledge has ended (HF1=0)
_exit	
        ENDM
