       opt     nocex,nocl,nocm,nomd,mu
NEXTHEADER  MACRO   S_R
; Written by Keith Lent, University of Texas, 1988
; **********************
; SETUP GLOBAL VARIABLES
S_RATE  EQU     S_R

; **********************
; START WIRE SPACE AT Y:$0
        ORG Y:$0
        ORG YL:$80
        ORG YH:8192   ;************ note, the last 512 words of external mem are used for dma buffer
        ORG X:$10       ;SKIP OVER THE POSSIBLE MIDI POINTERS
        ORG XL:$80
        ORG XH:$200
        ORG P:$30
        ORG PH:$20,YH:$3E20
        ORG PL:$0
; **********************
	include	'ioequ.asm'

DMA_R_REQ	equ	$050001		; message to host to request DMA transfer
DMA_DONE	equ	0
XRAMLO	equ	8192+8192-512  ; the base of the DMA buffer (in y memory)

;  MEMORY used for dma output
	ORG X:
x_DMA_flags		dc	0
x_OutputValue	dc	0
;;x_DMA_flags	equ	$00ff
;x_OutputValue	equ	$00fe
	ORG Y:
y_DMA_size		dc	0
y_Buffer_count	dc	0
;y_DMA_size	equ	$00ff
;y_Buffer_count	equ	$00fe



;; INTERRUPT VECTORS
	org	p:$0
	jmp	<reset			; reset interrupt

	org	p:$0024			; set flag when dma transfer done
	bset	#DMA_DONE,x:x_DMA_flags
	nop

;	org	p:$0026			; host command to start sine wave send
;	jmp	<main

;	org	p:$0028			; host command to stop sine wave send
;	jmp	<$0028
;	jmp	<reset



;; RESET ROUTINE
	org	p:
reset
	MOVE    #$FF,M7			;TABLE SIZE IS 256
	movec	#6,omr			; chip set to mode 2; ROM enabled
	bset	#0,x:m_pbc		; configure port B so it acts as host interface
	bset	#3,x:m_pcddr		; program pin 3 (pc3) of port C to be output
	
	bclr	#3,x:m_pcd		; zero to enable the external ram
	
	movep	#>$000000,x:m_bcr	; set 0 wait states for all external RAM
	movep	#>$00b400,x:m_ipr	; set interrupt priority register to SSI=0, SCI=1, HOST=0

	move	#>$0200,a
	move	a,y:y_DMA_size		; set buffersize to 512
	move	#>XRAMLO,r6		; set pointer to beginning of DMA buffer
	move	#-1,m6	;QQQQQQQ
	
	clr	a
	move	a,x:x_DMA_flags		; clear DMA flags
	move 	a,y:y_Buffer_count	; set Buffer count to 0

	bset	#m_hcie,x:m_hcr		; enable host command interrupts
	move	#0,sr			; unmask interrupts
	jmp	<kBEGIN
	
;; PUTHOST SUBROUTINE
putHost
	move	a,x:x_OutputValue	; store a, so we can restore it at end of routine
	move	a,x:(r6)+		; put output value into DMA register, increment pointer

	move	y:y_Buffer_count,b
	move	#>1,a
	add	a,b
	move	b,y:y_Buffer_count	; increment buffer count by 1

	move	y:y_DMA_size,a
	cmp	b,a
	jgt	_exit			; if Buffer count < DMA size, exit
					; (only send DMA buffer when it is full)

_transfer
	jclr	#m_htde,x:m_hsr,_transfer	; loop until htde bit HSR is set
	movep	#DMA_R_REQ,x:m_htx	; send DMA initiate read message to host

_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	; loop until host acknowledges (HF1=1)

	move	#>XRAMLO,r6		; point to beginning of DMA buffer
	move	y:y_DMA_size,b		; initialize loop size
	do	b,_send_loop		; top of DMA buffer send loop
_send	jclr	#m_htde,x:m_hsr,_send	; loop until htde bit of HSR is set
	movep	x:(r6)+,x:m_htx		; send buffer element to host
_send_loop
	btst	#DMA_DONE,x:x_DMA_flags	; if interrupt has set flags, then go to end
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_send_loop	; else keep sending zeroes until interrupt sets flags
	movep	#0,x:m_htx
	jmp	_send_loop
_endDMA
	bclr	#DMA_DONE,x:x_DMA_flags	; reset flag to 0, we know we are done--be ready to
					; set flag on next interrupt
_ackEnd
	jset	#m_hf1,x:m_hsr,_ackEnd	; loop until host acknowledge has ended (HF1=0)
	move	#>XRAMLO,r6		; reset DMA buffer pointer to beginning
	clr	a			; reset buffer count
	move	a,y:y_Buffer_count
_exit	move	x:x_OutputValue,a	; put output value into a, in case it's needed by the
	rts				; calling routine


kBEGIN		;the following code is inside the sample loop, i.e. done for every sample
		jclr #m_hrdf,x:m_hsr,_skip	; skip if no data from host
		movep	x:m_hrx,r3		; get the address from the host
_loop	jclr #m_hrdf,x:m_hsr,_loop	; loop untill hrdf bit of HSR becomes set
		movep	x:m_hrx,y:(r3)		; get the new wire value
_skip
        ENDM
