       opt     nocex,nocl,nocm,nomd,mu
NEXTHEADER  MACRO   S_R
; Written by Keith Lent, University of Texas, 1988
; **********************
; SETUP GLOBAL VARIABLES
S_RATE  EQU     S_R
; SETUP some constants for the Digital Ears interupt driven input routines
IOBufLen     EQU     256
IOBufLoc     EQU    8192+8192-512-256

; **********************
; START WIRE SPACE AT Y:$0
        ORG Y:$0
        ORG YL:$80
        ORG YH:8192   ;********* note, the last 512+256 words of external mem are used for buffers
        ORG X:$10       ;SKIP OVER THE POSSIBLE MIDI POINTERS
        ORG XL:$80
        ORG XH:$200
        ORG P:$30
        ORG PH:$20,YH:$3E20
        ORG PL:$0
; **********************
	IOEQU					;include	motorolas  'ioequ.asm'

DMA_R_REQ	equ	$050001		; message to host to request DMA transfer
DMA_DONE	equ	0
XDMABUF	equ	8192+8192-512  ; the base of the DMA buffer (in y memory)
DMASIZE	equ	512			;dma buffer and transfer size
;	**************  The Dma buffer is filled  and transfered out by the NEXTOUT macro.
;  MEMORY used for dma output
	ORG X:
x_DMA_flags		dc	0
	ORG Y:
y_OutputPtr	dc	XDMABUF

;; INTERRUPT VECTORS
	org	p:$0
	jmp	<reset			; reset interrupt

	org     p:$C			;ssi recieve interupt
	movep   X:$FFEF,Y:(R6)+
	nop
	org     p:$E			;ssi recieve interupt with error
	movep   X:$FFEF,Y:(R6)+
	nop

	org	p:$0024			; set flag when dma transfer done
	bset	#DMA_DONE,x:x_DMA_flags
	nop


;; RESET ROUTINE
	org	p:
reset
	MOVE    #$FF,M7			;TABLE SIZE IS 256
	movec	#6,omr			; chip set to mode 2; ROM enabled
	bset	#0,x:m_pbc		; configure port B so it acts as host interface
	bset	#3,x:m_pcddr		; program pin 3 (pc3) of port C to be output	
	bclr	#3,x:m_pcd		; zero to enable the external ram
	movep	#>$000000,x:m_bcr	; set 0 wait states for all external RAM
	movep	#>$00b400,x:m_ipr	; set interrupt priority register to SSI=0, SCI=1, HOST=0
	move	#XDMABUF,a
	move	a,y:y_OutputPtr		;not necessary, but reinitialize any way
	clr	a
	move	a,x:x_DMA_flags		; clear DMA flags
	bset		#m_hcie,x:m_hcr		; enable host command interrupts
			;set ssi for Digital Ears interupts
	MOVE    #IOBufLoc,R6		;R6 =  interupt driven INPUT POINTER
	MOVE    #IOBufLen-1,M6
	movep	#>$0001f7,x:m_pcc	;make all port c pins funtion as serial ports
	movep	#$4100,x:m_cra		;ssi word length=16, frc=1 (continuous)
	movep	#$aa00,x:m_crb		;rcv. int. enable
	move	#0,sr			; unmask interrupts

kBEGIN		;the following code is inside the sample loop, i.e. done for every sample
			;it gets the wire value changes from the host
		jclr #m_hrdf,x:m_hsr,_skip	; skip if no data from host
		movep	x:m_hrx,r3		; get the address from the host
_loop	jclr #m_hrdf,x:m_hsr,_loop	; loop untill hrdf bit of HSR becomes set
		movep	x:m_hrx,y:(r3)		; get the new wire value
_skip
        ENDM
