INOUT   MACRO   ROUT,LOUT,RIN,LIN,CH_POS,CH_LEN
; Written by Keith Lent and Peter Silsbee, University of Texas, 1989
;                       CH_POS = POSITION IN CHAIN
;                       CH_LEN = LENGTH OF CHAIN
;                       1ST IN CHAIN DOES BIT-REVERSAL ON INPUT
;                       LAST IN CHAIN DOES BIT-REVERSAL ON OUTPUT
; OUTPUT DATA TO SSI

        ORG     X:
_IOLOC  DC      IOBufLoc
        ORG     P:
        MOVE    #$8000,R0
        MOVE    X:_IOLOC,B
        MOVE    B,R7
        MOVE    #IOBufLen-1,M7
_IOWAITL
        MOVE    R6,A
        CMP     A,B     Y:ROUT,X0
        JEQ     _IOWAITL
        MOVE    Y:(R7),Y0
        IF      (CH_POS==1)
                MOVE    Y0,X:(R0)       ; harware bit reversal
                MOVE    X:(R0),Y0
        ENDIF
        MOVE    Y0,Y:LIN
        IF      (CH_POS==CH_LEN)
                MOVE    X0,X:(R0)
                MOVE    X:(R0),X0
        ENDIF
        MOVE    X0,Y:(R7)+
        IF      (S_RATE<30000)  ; CUT SR IN HALF
           MOVE X0,Y1
        ENDIF
        MOVE    R7,B
_IOWAITR
        MOVE    R6,A
        CMP     A,B     Y:LOUT,X0
        JEQ     _IOWAITR
        MOVE    Y:(R7),Y0
        IF      (CH_POS==1)
                MOVE    Y0,X:(R0)
                MOVE    X:(R0),Y0
        ENDIF
        MOVE    Y0,Y:RIN
        IF      (CH_POS==CH_LEN)
                MOVE    X0,X:(R0)
                MOVE    X:(R0),X0
        ENDIF
        MOVE    X0,Y:(R7)+
        IF      (S_RATE<30000)  ;CUT SR IN HALF
           MOVE    R7,B
_IOWAITL2
           MOVE    R6,A
           CMP     A,B
           JEQ     _IOWAITL2
           MOVE    Y1,Y:(R7)+
           MOVE    R7,B
_IOWAITR2
           MOVE    R6,A
           CMP     A,B
           JEQ     _IOWAITR2
           MOVE    X0,Y:(R7)+
        ENDIF
        MOVE    #255,M7
        MOVE    R7,X:_IOLOC
        ENDM
