#import "Graphic.h"
#import <appkit/tiff.h>

@interface Tiff : Graphic
{
    id cache;		/* the off-screen cache of the tiff image */
    char *data;		/* the tiff file data */
    NXSize lastSize;	/* the size of the cache */
    NXImageInfo info;	/* the pertinent information about the tiff image */
}

/* Factory methods */

+ setDrawWithAlpha:(BOOL)flag;
+ newFromStream:(NXStream *)stream;

/* Private methods */

- createCache;
- (BOOL)readTIFFFromStream:(NXStream *)stream;

/* Free method */

- free;

/* Overridden from superclass */

- (float)naturalAspectRatio;
- (BOOL)isOpaque;
- draw;

/* Archiving methods */

- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

@end

