#import "Graphic.h"

@interface TextGraphic : Graphic
{
    char *data;			/* the rich text */
    int length;			/* the length of data */
}

/* Factory methods */

+ (BOOL)isEditable;
+ cursor;
+ new;

/* Methods overridden from superclass */

- (BOOL)create:(NXEvent *)event in:view;
- (BOOL)edit:(NXEvent *)event in:view;
- draw;
- (BOOL)isOpaque;
- (BOOL)isValid;

/* Text delegate methods */

- textDidEnd:textObject endChar:(unsigned short)endChar;

/* Archiving methods */

- awake;
- read:(NXTypedStream *)stream;
- write:(NXTypedStream *)stream;

- (BOOL)solderTo:(NXPoint *)p;   /*KHL*/
- (char *) theWireOrTextName;

@end

