#import "Graphic.h"

#define CHUNK_SIZE 64	/* this is a malloc "good size" */

@interface Scribble : Graphic
{
    float *points;	/* the points in the scribble */
    char *userPathOps;	/* the linetos */
    int length;		/* the number of points */
    float bbox[4];	/* the bounding box of the scribble */
}

/* Factory methods */

+ cursor;

/* Free method */

- free;

/* Private methods */

- allocateChunk;

/* Methods overridden from superclass */

- (float)naturalAspectRatio;
- (int)moveCorner:(int)corner to:(const NXPoint *)point constrain:(BOOL)flag;
- (BOOL)create:(NXEvent *)event in:view;
- draw;

/* Archiving methods */

- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

@end

