#import "Rectangle.h"
#import "draw.h"

@implementation Rectangle : Graphic
/*
 * This is the canonical Graphic.
 * It doesn't get much simpler than this.
 */

- (float)naturalAspectRatio
/*
 * The natural aspect ratio of a rectangle is 1.0 (a square).
 */
{
    return 1.0;
}

- draw
{
    if (bounds.size.width < 1.0 || bounds.size.height < 1.0) return self;

    if (gFlags.eofill || gFlags.fill) {
	if (gFlags.isFramed) {
	    PSRectangle(bounds.origin.x, bounds.origin.y,
		        bounds.size.width, bounds.size.height);
	} else {
	    PSFilledRectangle(bounds.origin.x, bounds.origin.y,
			      bounds.size.width, bounds.size.height);
	}
    } else {
	PSFramedRectangle(bounds.origin.x, bounds.origin.y,
		          bounds.size.width, bounds.size.height);
    }

    return self;
}

@end

