#import "Graphic.h"

@interface PSGraphic : Graphic
{
    id cache;		/* the cached bits of the last rendering of the PS */
    char *data;		/* the ascii PostScript */
    int length;		/* the number of bytes in data */
    int maxlen;		/* size of vm_allocated region */
    float bbox[4];	/* the bounding box of the PostScript */
}

/* Private methods */

- (BOOL)readPSFromStream:(NXStream *)stream;

/* Factory methods */

+ newFromStream:(NXStream *)stream;

/* Free method */

- free;

/* Overridden from superclass */

- (BOOL)isOpaque;
- (float)naturalAspectRatio;
- draw;

/* Archiving methods */

- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

@end

