#import "Graphic.h"

@interface Line : Graphic
{
    int startCorner;	/* corner we start creating from */
}

/* Initialization method */

+ initialize;

/* Factory method */

+ new;

/* Methods overridden from superclass */

- (BOOL)isValid;
- (int)moveCorner:(int)corner to:(const NXPoint *)point constrain:(BOOL)flag;
- constrainCorner:(int)corner toAspectRatio:(float)ratio;
- (int)cornerMask;
- draw;
- (BOOL)hit:(const NXPoint *)point;

/* Methods to be overridden by subclassers */

- (float)arrowAngle:(int)corner;
- drawLine;

/* Archiving */

- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

@end

