/* NXRunAlertPanel("title here", "I am here creating new device", "OK", NULL, NULL);  */

/* Generated by Interface Builder */

#import <appkit/appkit.h>
#import <objc/hashtable.h>
#import "GraphicView.h"
#import "Kdevice.h"
#include <strings.h>
#import "deviceInspectorView.h"
#import "DrawApp.h"

#define	DOTSIZE 4.0
extern void KDrawBlackDot(float h,float v);
extern BOOL KIsNear(float h1,float v1,float h2,float v2);


@implementation Kdevice

+ (BOOL)isEditable
{
    return YES;
}

+newFromPasteboard
{
	int	i;
	NXSize	bitmapSize;
    id pasteboard;    
    const char  *const *array;
    char		*data;
    int			length;
    NXStream	*stream;
    	id	tempBitmap;

    pasteboard = [NXApp pasteboard];
    array = [pasteboard types];
    for(array = [pasteboard types];*array;array++)
    	if(!strcmp(*array,NXTIFFPboard))
		break;
    if(!(*array)) {
    	NXRunAlertPanel("Sorry !", "No Tiff format objects are in the pasteboard", "OK", NULL, NULL);
	return nil;
    }
  	[pasteboard readType:NXTIFFPboard data:&data length:&length];
	stream = NXOpenMemory(data,length,NX_READONLY);
	tempBitmap = [Bitmap newFromStream:stream];
	NXCloseMemory(stream,NX_FREEBUFFER);

    if(!tempBitmap) {
    	NXRunAlertPanel("Error", "Tiff format bitmap could not be read from the pasteboard", "OK", NULL, NULL);
	return nil;
    }
	self = [super new];
	deviceBitmap = tempBitmap;
	title = NXCopyStringBuffer("Put a helpful description of this new device here...");
	code = NXCopyStringBuffer("Put the source code for the device here...");
	for(i=0;i<9;i++) {
		wireName[i] = NXCopyStringBuffer("");
		wirePointH[i] = -999.;
	}
	[deviceBitmap getSize:&bitmapSize];
	bounds.size.width = bitmapSize.width+2.0*DOTSIZE;
	bounds.size.height = bitmapSize.height+2.0*DOTSIZE;
	return self;
}

- (char *) title
{
	return	title;
}

- (char *) code
{
	return	code;
}

- (char *)wireName: (int) i
{
	return	wireName[i];
}

- (NXCoord)wirePointH: (int) i;
{
	return	wirePointH[i];
}

- (NXCoord)wirePointV: (int) i;
{
	return	wirePointV[i];
}

- (id)deviceBitmap;
{
	return	deviceBitmap;
}

- setTitle:(char *)newTitle;
{
	NX_FREE(title);
	title = newTitle;
	return	self;
}

- setCode: (char *)newCode;
{
	NX_FREE(code);
	code = newCode;
	return	self;
}

- setWireName:(char *)name number: (int) i;
{
	NX_FREE(wireName[i]);
	wireName[i] = name;
	return	self;
}

- setWirePointH: (NXCoord)H number: (int) i;
{
	wirePointH[i] = H;
	return	self;
}

- setWirePointV:(NXCoord)V number: (int) i;
{
	wirePointV[i] = V;
	return	self;
}

- free;
{
	int	i;
	NX_FREE(title);
	NX_FREE(code);
	for(i=0;i<9;i++) NX_FREE(wireName[i]);
	[deviceBitmap free];
	return	[super free];
}

BOOL resizeAlert = YES;
- resize:(NXEvent *)event by:(int)corner in:view
{
	NXBeep(); 
	if(resizeAlert)
//		if(NXRunAlertPanel("Sorry", "Devices can not be resized.", "Don't print this message again", "Cancel", NULL) != NX_ALERTDEFAULT)
		NXRunAlertPanel("Sorry", "Devices can not be resized.", "OK",NULL, NULL);
	resizeAlert = NO;
	return self;
}

- (BOOL)edit:(NXEvent *)event in:view
{
	id  graphicView;
	graphicView = [view superview];
	if([[NXApp myDeviceInspectorView] editDeviceModal:self]) {
		[graphicView cache:&bounds];
		[[graphicView window] flushWindow];
		[graphicView dirty];
	}
	return YES;
}

- draw
{
	int	i;
	NXPoint	spot;
	spot.x = DOTSIZE+bounds.origin.x;
	spot.y = DOTSIZE+bounds.origin.y;
 	[deviceBitmap composite:NX_SOVER toPoint:&spot];
	for(i=0;i<9;i++)
		if(wirePointH[i] != -999)
			KDrawBlackDot(bounds.origin.x+DOTSIZE+wirePointH[i],bounds.origin.y+DOTSIZE+wirePointV[i]);						
	return self;
}

- write:(NXTypedStream *)stream
{
    int titleLen,codeLen,wireNameLen[9],i;
	titleLen = strlen(title);
	codeLen = strlen(code);
	for(i=0;i<9;i++)  wireNameLen[i] = strlen(wireName[i]);
    [super write:stream];
	NXWriteTypes(stream, "ii", &titleLen, &codeLen);
	for(i=0;i<9;i++)  NXWriteTypes(stream, "i", &wireNameLen[i]);
	NXWriteArray(stream, "c", titleLen,title);
	NXWriteArray(stream, "c", codeLen,code);
	for(i=0;i<9;i++)  NXWriteArray(stream, "c", wireNameLen[i],wireName[i]);
	for(i=0;i<9;i++)  NXWriteTypes(stream, "ff", &wirePointH[i],&wirePointV[i]);
	NXWriteObject(stream,deviceBitmap);
    return self;
}

- read:(NXTypedStream *)stream
{
    int titleLen,codeLen,wireNameLen[9],i;
    [super read:stream];
	NXReadTypes(stream, "ii", &titleLen, &codeLen);
	for(i=0;i<9;i++)  NXReadTypes(stream, "i", &wireNameLen[i]);
    NX_MALLOC(title, char, titleLen+1);
    NX_MALLOC(code, char, codeLen+1);
    for(i=0;i<9;i++) NX_MALLOC(wireName[i], char, wireNameLen[i]+1);
	NXReadArray(stream, "c", titleLen,title);
	NXReadArray(stream, "c", codeLen,code);
	for(i=0;i<9;i++)  NXReadArray(stream, "c", wireNameLen[i],wireName[i]);
    title[titleLen] = '\0';
    code[codeLen] = '\0';
    for(i=0;i<9;i++) wireName[i][wireNameLen[i]] = '\0';
	for(i=0;i<9;i++)  NXReadTypes(stream, "ff", &wirePointH[i],&wirePointV[i]);
	deviceBitmap = NXReadObject(stream);
    return self;
}

- (BOOL)solderTo:(NXPoint *)p
{
	int	i;
	for(i=0;i<9;i++)
		if(wirePointH[i] != -999)
			if(KIsNear(p->x,p->y,bounds.origin.x+DOTSIZE+wirePointH[i],bounds.origin.y+DOTSIZE+wirePointV[i])) {
				p->x =bounds.origin.x+DOTSIZE+wirePointH[i];
				p->y =bounds.origin.y+DOTSIZE+wirePointV[i];
				return	YES;
			}
	return	NO;
}


@end
