#import <appkit/Panel.h>

@interface InspectorPanel : Panel
{
    id	lineWidthField;
    id	lineWidthSlider;
    id	graySlider;
    id	grayField;
    id	widthForm;
    id	heightForm;
    id	filledButton;
    id	framedButton;
    id  lineCapButton;
    id	lineArrowButton;
    id  lineJoinButton;
    id  selectedGraphic;	/* the currently displayed graphic */
    id  graphicView;		/* the view selectedGraphic is in */
    NXSize lastSize;		/* the last size displayed */
    BOOL initialized;		/* whether the PULs have been attached */
}

/* Private methods */

- reloadGraphic:graphic;
- loadGraphic:graphic;

/* Public methods */

- load:graphicView;
- initializeGraphic:graphic;

/* Overridden from superclass */

- orderWindow:(int )place relativeTo:(int )otherWin;
- update;

/* Target/Action methods */

- changeFramed:sender;
- changeFill:sender;
- changeLineCap:sender;
- changeLineArrow:sender;
- changeLineJoin:sender;
- changeLineWidth:sender;
- changeGray:sender;
- changeDimensions:sender;

/* Private PopUpList attachment methods */

- attachFillPUL:button;
- attachFramePUL:button;
- attachLineCapPUL:button;
- attachLineArrowPUL:button;
- attachLineJoinPUL:button;
- attachPULs;

@end
