#import <appkit/Responder.h>
#import <appkit/graphics.h>

@interface DrawDocument : Responder
{
    id view;			/* the document's GraphicView */
    id window;			/* the window the GraphicView is in */
    id printInfo;		/* the print information for the GraphicView */
    id listener;		/* the icon-dragging listener */
    char *name;			/* the name of the document */
    char *directory;		/* the directory it is in */
    char *iconPathList;		/* list of files last dragged over document */
    BOOL haveSavedDocument;	/* whether document has associated disk file */
}

/* Very private instance method needed by factory methods */

- (BOOL)loadDocument:(NXStream *)stream frameSize:(NXRect *)frame;

/* Factory methods */

+ new;
+ newFromStream:(NXStream *)stream;
+ newFromFile:(const char *)file;

/* Public methods */

- free;

- loadPostScriptFile:(const char *)file at:(const NXPoint *)p;
- loadTIFFFile:(const char *)file at:(const NXPoint *)p;

- resetScrollers;

- view;
- printInfo;

/* Target/Action methods */

- changeLayout:sender;
- changeGrid:sender;
- save:sender;
- saveAs:sender;
- saveTo:sender;
- revertToSaved:sender;

/* Private method used by saveTo: method */

- changeSaveType:sender;

/* Document name and file handling methods */

- (const char *)filename;
- (const char *)directory;
- (const char *)name;
- setName:(const char *)name andDirectory:(const char *)directory;
- setName:(const char *)name;
- saveTo:(const char *)type using:(SEL)streamWriter;
- save;

/* Window delegate methods */

- windowDidBecomeMain:sender;
- windowWillClose:sender;
- windowWillResize:sender toSize:(NXSize *)size;
- windowDidResize:sender;

/* Workspace Manager icon-dragging methods */

//- registerWindow;
//- unregisterWindow;
//- (int)iconEntered:(int)windowNum at:(double)x :(double)y
//    iconWindow:(int)iconWindowNum iconX:(double)iconX iconY:(double)iconY
//    iconWidth:(double)iconWidth iconHeight:(double)iconHeight
//    pathList:(char *)pathList;
//- (int)iconReleasedAt:(double)x :(double)y ok:(int *)flag;

/* Menu command validation method */

- (BOOL)validateCommand:menuCell;

/* Cursor setting */

- resetCursor;

@end

