//Written by J. Laroche at the Center for Music Experiment at UCSD, San Diego //California. December 1990.

#import <sound/sound.h>
#import <sound/sounddriver.h>
#import <stdio.h>

#define Error(A,B) if((A)) {fprintf(stderr,"%s %s\n",B, SNDSoundError((A)));\
mach_error(B,(A)); }

#define DMASIZE 512


main (int argc, char *argv[])
{
    static port_t dev_port, owner_port, cmd_port, read_port;
    int i, protocol;
    kern_return_t k_err;
    SNDSoundStruct *dspStruct;
    int low_water = 48*1024;
    int high_water = 64*1024;

    // Acquire ownership of SoundOut and DSP...
    k_err = SNDAcquire(SND_ACCESS_OUT|SND_ACCESS_DSP,0,0,0,
    	NULL_NEGOTIATION_FUN,0,&dev_port,&owner_port);
    Error(k_err,"SNDOUT and DSP acquisition");
    
    // Do NOT ramp-up sounds, since this induces an extra delay in the 
    // DSP -> Dacs stream (ramp computation time...)
    k_err = snddriver_set_ramp(dev_port,0);
    
    // These two functions, not documented, modify the number and size of the
    // sound out buffers in the driver. Make them short to lower response time
    // for more info, see /usr/include/sound/snddriver_client.h
    k_err = snddriver_set_sndout_bufsize(dev_port,owner_port,512);
    k_err = snddriver_set_sndout_bufcount(dev_port,owner_port,4);
    
    
    // Retrieve the DSP's command port...
    k_err = snddriver_get_dsp_cmd_port(dev_port,owner_port,&cmd_port);
    
    // Initialize the driver's protocol, and set-up a stream from DSP to DACS.
    protocol = SNDDRIVER_DSP_PROTO_RAW;
    k_err = snddriver_stream_setup(dev_port, owner_port,
		    		SNDDRIVER_STREAM_DSP_TO_SNDOUT_44,
				DMASIZE, 2, 
				low_water, high_water,
				&protocol, &read_port);
    Error(k_err,"Stream");
				
    // Then set-up the driver with the returned modified protocol...
    k_err = snddriver_dsp_protocol(dev_port, owner_port, protocol);
    Error(k_err,"Protocol");

    // Read the DSP code file...
    k_err = SNDReadDSPfile("perso_b.lod", &dspStruct, NULL);
    Error(k_err,"DSP file");

    // ... and boot the dsp
    k_err = SNDBootDSP(dev_port, owner_port, dspStruct);
    Error(k_err,"DSP BOOT");
    
    // Loop while the dsp is sending the samples, passing it a volume value
    while(1)
    {
    
	printf("Volume? Max = 2^^23-1 = 8388607 Min = 0\n");
	scanf("%d",&i);
	
	// To pass a value to the DSP, write it first....
	k_err = snddriver_dsp_write(cmd_port,&i,1,sizeof(int),
   						SNDDRIVER_LOW_PRIORITY);
	
	// Then issue a host command to tell the DSP to go fetch the value...
	k_err = snddriver_dsp_host_cmd(cmd_port,20,
   						SNDDRIVER_LOW_PRIORITY);
    }
    
}


