;; An example of white noise generator. Adatped from the music Kit's 
;; unit generator


	include "ioequ.asm"

IW_Buff		equ	8192		;Start address of input buffer right
Buff_size	equ	8191
DMA_SIZE	equ	512

DM_R_REQ	equ	$050001		;message -> host to request dma
VEC_R_DONE	equ	$0024		;host command indicating dma complete


;;;------------------------- Variable locations
;;;

x_sFlags	equ	$00fd		;dspstream flags
DMA_DONE	equ	0		;  indicates that dma is complete
Stop_Flag	equ	00		; Stop DMA flag
scaler		equ	02
random		equ	04
depth		equ	05


	org	p:$0			
	jmp	reset

	org	p:VEC_R_DONE
	bset	#DMA_DONE,x:x_sFlags
	
	org	p:40			
	jsr	get

	org	p:60			
	jsr	stop

	org	p:100
	
reset
	movec   #6,omr			;data rom enabled, mode 2
	bset    #0,x:m_pbc		;host port
	bset	#3,x:m_pcddr		;   pc3 is an output with value
	bclr	#3,x:m_pcd		;   zero to enable the external ram
	movep   #>$000000,x:m_bcr	;no wait states on the external sram
        movep   #>$00BC00,x:m_ipr  	;intr levels: SSI=2, SCI=1, HOST=2
	clr	a
	move	a,x:x_sFlags		;clear flags
	bset    #m_hcie,x:m_hcr		;host command interrupts
	move	#0,sr			;enable interrupts
	
	jmp	main
	
		
main
	bclr	#0,x:Stop_Flag
	move	#>.99,a
	move	a,x:scaler
	move	#.2345,a
	move	a,x:random
	move	#.999,a
	move	a,x:depth

_main_loop
	jset	#0,x:Stop_Flag,_main_loop	;
	jclr	#m_htde,x:m_hsr,_main_loop	
	movep	#DM_R_REQ,x:m_htx	;    send "DSP_dm_R_REQ" to host
_ackBegin
	jclr	#m_hf1,x:m_hsr,_ackBegin	;    wait for HF1 to go high
	move	#>DMA_SIZE,b
	do	b,_prodDMA
	jsr	Rand
	move	a,X0
	move	#>$7FFF,Y0
	mpyr	X0,Y0,a
_wait
	jclr	#m_htde,x:m_hsr,_wait
	move	a,x:m_htx	
_prodDMA
	btst	#DMA_DONE,x:x_sFlags
	jcs	_endDMA
	jclr	#m_htde,x:m_hsr,_prodDMA
	movep	#0,x:m_htx		;send zeros until noticed
	jmp	_prodDMA
_endDMA
	bclr	#DMA_DONE,x:x_sFlags	;be sure we know we are through
_ackEnd
	jset	#m_hf1,x:m_hsr,_ackEnd	;wait for HF1 to go low (optional!)
	jmp	_main_loop


	
stop
	bset	#0,x:Stop_Flag
	rti
		
get
	movep	x:m_hrx,x:scaler 
	rti
		
Rand
	move	x:random,Y0
	move	#.24576534,b0
	tfr	b,a #5609937,Y1
	mac	Y0,Y1,a
	asr	a x:depth,X1
	move	a0,Y0 
	move	#.9999,a
	sub	X1,a x:scaler,X0
	mac	X1,Y0,a Y0,x:random
	move	a,Y0
	mpyr	Y0,X0,a		
	rts
	
	

