
/* Generated by Interface Builder */

#import "FIR.h"

@implementation FIR

- setSliders:anObject
{
    sliders = anObject;
    [self open];
    return self;
}

- open
{
int s_err;
int i;

    [super open];
    SNDReadDSPfile([self findPath:"/DSP_Code/FIR.lod"], &Effect, NULL);

    s_err = SNDBootDSP(dev_port, owner_port, Effect);
    if (s_err != SND_ERR_NONE) {
	fprintf(stderr,"Cannot boot dsp : %s\n", SNDSoundError(s_err));
	exit(1);
    }
    for(i=0;i<4;i++)
    {
	[sliders selectCellWithTag:i+1];
	[self sliderChange:sliders];
    }
    printf("DSP booted\n");
    return self;
}

- sliderChange:sender
{
int value;
int tag;
int DSPCommand;

    tag = [[sender selectedCell] tag] - 1;
    if(tag < 0) return self; 
    DSPCommand = 20 + tag;
    if(tag == 0)
    value = (int) exp(10.5*[sender floatValue]*log(2.)); 
    else value = [sender intValue];
    snddriver_dsp_write(cmd_port,&value,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);
    snddriver_dsp_host_cmd(cmd_port,DSPCommand,SNDDRIVER_MED_PRIORITY);
    return self;
}

@end
